/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.stack;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EmptyStackException;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.stack.Stack;

public class FixedCapacityArrayStack<E>
implements Stack<E>,
Cloneable,
Serializable {
    private E[] elements;
    private int next = 0;
    private int size = 0;
    private static final long serialVersionUID = 1L;

    public FixedCapacityArrayStack(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + capacity);
        }
        this.elements = new Object[capacity];
    }

    @Override
    public void push(E element) {
        if (this.isFull()) {
            throw new IllegalStateException("Stack is full.");
        }
        this.elements[this.next] = element;
        if (++this.next == this.elements.length) {
            this.next = 0;
        }
        ++this.size;
    }

    @Override
    public E pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        int index = this.next;
        if (index == 0) {
            index = this.elements.length;
        }
        E element = this.elements[--index];
        this.elements[index] = null;
        this.next = index;
        --this.size;
        return element;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        int index = this.next;
        if (index == 0) {
            index = this.elements.length;
        }
        return this.elements[--index];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.elements.length;
    }

    public FixedCapacityArrayStack<E> clone() {
        int len = this.elements.length;
        FixedCapacityArrayStack<E> clone = new FixedCapacityArrayStack<E>(len);
        System.arraycopy(this.elements, 0, clone.elements, 0, len);
        clone.next = this.next;
        clone.size = this.size;
        return clone;
    }

    public String toString() {
        return Arrays.toString(ArrayTools.reverse(this.copyElements()));
    }

    private Object[] copyElements() {
        int len = this.size;
        if (len == 0) {
            return ObjectTools.EMPTY_OBJECT_ARRAY;
        }
        Object[] result = new Object[len];
        System.arraycopy(this.elements, 0, result, 0, len);
        return result;
    }
}

