/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.util.Destructable;

public class DestructingGuard {
    private static final Logger LOGGER = Logger.getLogger(DestructingGuard.class.getName());
    private List<Destructable> destructables = new ArrayList<Destructable>(1);
    private boolean discharged = false;

    public void discharge() {
        this.discharged = true;
    }

    public void doFinally() {
        if (this.discharged) {
            return;
        }
        int i = this.destructables.size() - 1;
        while (i >= 0) {
            try {
                this.destructables.get(i).destruct();
            }
            catch (RuntimeException e) {
                this.handleFinallyProblem(e);
            }
            catch (Error e) {
                this.handleFinallyProblem(e);
            }
            --i;
        }
        this.discharged = true;
    }

    public void addValue(Destructable destructable) {
        this.destructables.add(destructable);
    }

    protected void handleFinallyProblem(RuntimeException e) {
        LOGGER.log(Level.SEVERE, "Exception in finally handler", e);
    }

    protected void handleFinallyProblem(Error e) {
        LOGGER.log(Level.SEVERE, "Exception in finally handler", e);
    }
}

