/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class RevealOperation
extends AbstractOperation
implements ITransactionalOperation {
    private double tx = 0.0;
    private double ty = 0.0;
    private InfiniteCanvasViewer viewer;
    private IVisualPart<? extends Node> part = null;

    public RevealOperation(IVisualPart<? extends Node> part) {
        super("Reveal");
        this.part = part;
        this.viewer = (InfiniteCanvasViewer)part.getRoot().getViewer();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.tx = this.viewer.getCanvas().getHorizontalScrollOffset();
        this.ty = this.viewer.getCanvas().getVerticalScrollOffset();
        this.viewer.reveal(this.part);
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setPart(IVisualPart<? extends Node> part) {
        this.part = part;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.viewer.getCanvas().setHorizontalScrollOffset(this.tx);
        this.viewer.getCanvas().setVerticalScrollOffset(this.ty);
        return Status.OK_STATUS;
    }
}

