/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.TimestampReplacement;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;

abstract class AbstractTimelyMaskedMemory<Timestamp extends Comparable<Timestamp>, KeyType>
extends MaskedTupleMemory<Timestamp> {
    protected final Map<KeyType, TimelyMemory<Timestamp>> memory = CollectionsFactory.createMap();

    public AbstractTimelyMaskedMemory(TupleMask mask, Object owner) {
        super(mask, owner);
    }

    @Override
    public void initializeWith(MaskedTupleMemory<Timestamp> other, Timestamp defaultValue) {
        Iterator<Tuple> itr = other.iterator();
        while (itr.hasNext()) {
            this.addWithTimestamp(itr.next(), defaultValue);
        }
    }

    @Override
    public void clear() {
        this.memory.clear();
    }

    @Override
    public int getKeysetSize() {
        return this.memory.keySet().size();
    }

    @Override
    public int getTotalSize() {
        int i = 0;
        for (Map.Entry<KeyType, TimelyMemory<Timestamp>> entry : this.memory.entrySet()) {
            i += entry.getValue().size();
        }
        return i;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.memory.values().stream().flatMap(e -> e.keySet().stream()).iterator();
    }

    protected Collection<Tuple> getInternal(KeyType key) {
        Map<Tuple, Timestamp> values = this.getWithTimestampInternal(key);
        if (values == null) {
            return null;
        }
        return values.keySet();
    }

    public Map<Tuple, Timestamp> getWithTimestampInternal(KeyType key) {
        TimelyMemory<Timestamp> values = this.memory.get(key);
        if (values == null) {
            return null;
        }
        return values.asMap();
    }

    protected TimestampReplacement<Timestamp> removeInternal(KeyType key, Tuple tuple, Timestamp timestamp) {
        TimelyMemory<Timestamp> values = this.memory.get(key);
        TimestampReplacement<Timestamp> result = null;
        if (values == null) {
            throw this.raiseDuplicateDeletion(tuple);
        }
        try {
            result = values.remove(tuple, timestamp);
        }
        catch (IllegalStateException e) {
            throw this.raiseDuplicateDeletion(tuple);
        }
        if (values.isEmpty()) {
            this.memory.remove(key);
        }
        return result;
    }

    protected TimestampReplacement<Timestamp> addInternal(KeyType key, Tuple tuple, Timestamp timestamp) {
        TimelyMemory<Timestamp> values = this.memory.get(key);
        if (values == null) {
            values = new TimelyMemory();
            this.memory.put(key, values);
        }
        return values.put(tuple, timestamp);
    }

    @Override
    public TimestampReplacement<Timestamp> removeWithTimestamp(Tuple tuple, Timestamp timestamp) {
        return this.removeWithTimestamp(tuple, null, timestamp);
    }

    @Override
    public TimestampReplacement<Timestamp> addWithTimestamp(Tuple tuple, Timestamp timestamp) {
        return this.addWithTimestamp(tuple, null, timestamp);
    }
}

