/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UIUtil {
    static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = UIUtil.blend(c1.red, c2.red, ratio);
        int g = UIUtil.blend(c1.green, c2.green, ratio);
        int b = UIUtil.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    static void drawArrow(GC gc, Rectangle rect, int style) {
        Point point = new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
        int[] points = null;
        switch (style) {
            case 16384: {
                points = new int[]{point.x + 2, point.y - 4, point.x + 2, point.y + 4, point.x - 2, point.y};
                gc.fillPolygon(points);
                break;
            }
            case 128: {
                gc.fillRectangle(new Rectangle(point.x, point.y - 1, 1, 1));
                gc.fillRectangle(new Rectangle(point.x - 1, point.y, 3, 1));
                gc.fillRectangle(new Rectangle(point.x - 2, point.y + 1, 5, 1));
                break;
            }
            case 131072: {
                points = new int[]{point.x - 2, point.y - 4, point.x - 2, point.y + 4, point.x + 2, point.y};
                gc.fillPolygon(points);
                break;
            }
            default: {
                gc.fillRectangle(new Rectangle(point.x - 2, point.y - 1, 5, 1));
                gc.fillRectangle(new Rectangle(point.x - 1, point.y, 3, 1));
                gc.fillRectangle(new Rectangle(point.x, point.y + 1, 1, 1));
            }
        }
    }

    static Shell getDefaultShell() {
        Shell shell = null;
        try {
            shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            if (shell == null) {
                shell = Display.getCurrent().getActiveShell();
            }
            if (shell == null) {
                shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            }
        }
        catch (Exception exception) {}
        if (shell == null) {
            return new Shell();
        }
        return shell;
    }
}

