/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisable;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.security.CDOPermissionProvider;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeFile;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeFileOperation;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStore;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionUnchunker;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.DataInputExtender;
import org.eclipse.net4j.util.io.DataInputOutputFile;
import org.eclipse.net4j.util.io.DataOutputExtender;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedIOUtil;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.om.OMPlatform;

public class LissomeFileHandle
extends DataInputOutputFile
implements CDODataInput,
CDODataOutput,
LissomeFile.RevisionProvider {
    private static final boolean X_COMPRESSION = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.server.lissome.X_COMPRESSION");
    private LissomeFile file;
    private CDODataInput in;
    private CDODataOutput out;

    public LissomeFileHandle(LissomeFile file, String mode) throws FileNotFoundException {
        super((File)file, mode);
        this.file = file;
    }

    public LissomeFile getFile() {
        return this.file;
    }

    public LissomeStore getStore() {
        return this.file.getStore();
    }

    public CDOPackageRegistry getPackageRegistry() {
        return this.getStore().getRepository().getPackageRegistry();
    }

    public CDOBranchManager getBranchManager() {
        return this.getStore().getRepository().getBranchManager();
    }

    public CDOCommitInfoManager getCommitInfoManager() {
        return this.getStore().getRepository().getCommitInfoManager();
    }

    public CDORevisionUnchunker getRevisionUnchunker() {
        return null;
    }

    public CDORevisionFactory getRevisionFactory() {
        return CDORevisionFactory.DEFAULT;
    }

    public CDOListFactory getListFactory() {
        return CDOListFactory.DEFAULT;
    }

    public CDOLobStore getLobStore() {
        return null;
    }

    public CDOIDProvider getIDProvider() {
        return CDOIDProvider.NOOP;
    }

    public CDOPermissionProvider getPermissionProvider() {
        return this.out().getPermissionProvider();
    }

    @Override
    public CDORevision getRevision(long pointer) {
        try {
            this.seek(pointer);
            return this.readCDORevision();
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    private CDODataInput in() {
        if (this.in == null) {
            this.in = this.createDataInput();
        }
        return this.in;
    }

    protected CDODataInput createDataInput() {
        DataInputExtender extendedDataInput = new DataInputExtender((DataInput)((Object)this));
        return new CDODataInputImpl((ExtendedDataInput)extendedDataInput){

            public CDORevision readCDORevision(boolean freeze) throws IOException {
                boolean detached = this.readBoolean();
                if (detached) {
                    int cid = this.readXInt();
                    EClass eClass = (EClass)LissomeFileHandle.this.file.getStore().getMetaObject(cid);
                    CDOID id = this.readCDOID();
                    CDOBranch branch = this.readCDOBranch();
                    int version = this.readXInt();
                    long timeStamp = this.readXLong();
                    long revised = this.readXLong();
                    return new DetachedCDORevision(eClass, id, branch, version, timeStamp, revised);
                }
                return super.readCDORevision(freeze);
            }

            public CDOPackageRegistry getPackageRegistry() {
                return LissomeFileHandle.this.getPackageRegistry();
            }

            protected CDOBranchManager getBranchManager() {
                return LissomeFileHandle.this.getBranchManager();
            }

            protected CDOCommitInfoManager getCommitInfoManager() {
                return LissomeFileHandle.this.getCommitInfoManager();
            }

            protected CDORevisionFactory getRevisionFactory() {
                return LissomeFileHandle.this.getRevisionFactory();
            }

            protected CDOListFactory getListFactory() {
                return LissomeFileHandle.this.getListFactory();
            }

            protected CDOLobStore getLobStore() {
                return LissomeFileHandle.this.getLobStore();
            }
        };
    }

    public int readVarInt() throws IOException {
        return ExtendedIOUtil.readVarInt((DataInput)this.in());
    }

    public long readVarLong() throws IOException {
        return ExtendedIOUtil.readVarLong((DataInput)this.in());
    }

    public int readXInt() throws IOException {
        if (this.isXCompression()) {
            return this.readVarInt();
        }
        return this.readInt();
    }

    public long readXLong() throws IOException {
        if (this.isXCompression()) {
            return this.readVarLong();
        }
        return this.readLong();
    }

    public byte[] readByteArray() throws IOException {
        return this.in().readByteArray();
    }

    public Object readObject() throws IOException {
        return this.in().readObject();
    }

    public Object readObject(ClassLoader classLoader) throws IOException {
        return this.in().readObject(classLoader);
    }

    public Object readObject(ExtendedIOUtil.ClassResolver classResolver) throws IOException {
        return this.in().readObject(classResolver);
    }

    public String readString() throws IOException {
        return this.in().readString();
    }

    public <T extends Enum<?>> T readEnum(Class<T> type) throws IOException {
        return (T)this.in().readEnum(type);
    }

    public Throwable readException() throws IOException {
        return this.in().readException();
    }

    public CDOPackageUnit readCDOPackageUnit(ResourceSet resourceSet) throws IOException {
        return this.in().readCDOPackageUnit(resourceSet);
    }

    public CDOPackageUnit[] readCDOPackageUnits(ResourceSet resourceSet) throws IOException {
        return this.in().readCDOPackageUnits(resourceSet);
    }

    public CDOPackageUnit.Type readCDOPackageUnitType() throws IOException {
        return this.in().readCDOPackageUnitType();
    }

    public CDOPackageInfo readCDOPackageInfo() throws IOException {
        return this.in().readCDOPackageInfo();
    }

    public CDOClassifierRef readCDOClassifierRef() throws IOException {
        return this.in().readCDOClassifierRef();
    }

    public EClassifier readCDOClassifierRefAndResolve() throws IOException {
        return this.in().readCDOClassifierRefAndResolve();
    }

    public String readCDOPackageURI() throws IOException {
        return this.in().readCDOPackageURI();
    }

    public CDOType readCDOType() throws IOException {
        return this.in().readCDOType();
    }

    public CDOBranch readCDOBranch() throws IOException {
        return this.in().readCDOBranch();
    }

    public CDOBranchPoint readCDOBranchPoint() throws IOException {
        return this.in().readCDOBranchPoint();
    }

    public CDOBranchVersion readCDOBranchVersion() throws IOException {
        return this.in().readCDOBranchVersion();
    }

    public CDOChangeSetData readCDOChangeSetData() throws IOException {
        return this.in().readCDOChangeSetData();
    }

    public CDOCommitData readCDOCommitData() throws IOException {
        return this.in().readCDOCommitData();
    }

    public CDOCommitInfo readCDOCommitInfo() throws IOException {
        return this.in().readCDOCommitInfo();
    }

    public CDOID readCDOID() throws IOException {
        return this.in().readCDOID();
    }

    public CDOIDReference readCDOIDReference() throws IOException {
        return this.in().readCDOIDReference();
    }

    public CDOIDAndVersion readCDOIDAndVersion() throws IOException {
        return this.in().readCDOIDAndVersion();
    }

    public CDOIDAndBranch readCDOIDAndBranch() throws IOException {
        return this.in().readCDOIDAndBranch();
    }

    public CDORevisionKey readCDORevisionKey() throws IOException {
        return this.in().readCDORevisionKey();
    }

    public CDORevision readCDORevision() throws IOException {
        return this.in().readCDORevision();
    }

    public CDORevision readCDORevision(boolean freeze) throws IOException {
        return this.in().readCDORevision(freeze);
    }

    public CDORevisable readCDORevisable() throws IOException {
        return this.in().readCDORevisable();
    }

    public CDOList readCDOList(EClass owner, EStructuralFeature feature) throws IOException {
        return this.in().readCDOList(owner, feature);
    }

    public Object readCDOFeatureValue(EStructuralFeature feature) throws IOException {
        return this.in().readCDOFeatureValue(feature);
    }

    public CDORevisionDelta readCDORevisionDelta() throws IOException {
        return this.in().readCDORevisionDelta();
    }

    public CDOFeatureDelta readCDOFeatureDelta(EClass owner) throws IOException {
        return this.in().readCDOFeatureDelta(owner);
    }

    public Object readCDORevisionOrPrimitive() throws IOException {
        return this.in().readCDORevisionOrPrimitive();
    }

    public Object readCDORevisionOrPrimitiveOrClassifier() throws IOException {
        return this.in().readCDORevisionOrPrimitiveOrClassifier();
    }

    public IRWLockManager.LockType readCDOLockType() throws IOException {
        return this.in().readCDOLockType();
    }

    public CDOLockChangeInfo readCDOLockChangeInfo() throws IOException {
        return this.in().readCDOLockChangeInfo();
    }

    public CDOLockOwner readCDOLockOwner() throws IOException {
        return this.in().readCDOLockOwner();
    }

    public CDOLockState readCDOLockState() throws IOException {
        return this.in().readCDOLockState();
    }

    public IDurableLockingManager.LockArea readCDOLockArea() throws IOException {
        return this.in().readCDOLockArea();
    }

    private CDODataOutput out() {
        if (this.out == null) {
            this.out = this.createDataOutput();
        }
        return this.out;
    }

    protected CDODataOutput createDataOutput() {
        DataOutputExtender extendedDataOutput = new DataOutputExtender((DataOutput)((Object)this));
        return new CDODataOutputImpl((ExtendedDataOutput)extendedDataOutput){

            public void writeCDORevision(CDORevision revision, int referenceChunk, CDOBranchPoint securityContext) throws IOException {
                boolean detached = revision instanceof DetachedCDORevision;
                this.writeBoolean(detached);
                if (detached) {
                    int cid = LissomeFileHandle.this.file.getStore().getMetaID(revision.getEClass());
                    this.writeXInt(cid);
                    this.writeCDOID(revision.getID());
                    this.writeCDOBranch(revision.getBranch());
                    this.writeXInt(revision.getVersion());
                    this.writeXLong(revision.getTimeStamp());
                    this.writeXLong(revision.getRevised());
                } else {
                    super.writeCDORevision(revision, referenceChunk, securityContext);
                }
            }

            public CDOPackageRegistry getPackageRegistry() {
                return LissomeFileHandle.this.getPackageRegistry();
            }

            public CDOIDProvider getIDProvider() {
                return LissomeFileHandle.this.getIDProvider();
            }
        };
    }

    public void writeVarInt(int v) throws IOException {
        ExtendedIOUtil.writeVarInt((DataOutput)this.out(), (int)v);
    }

    public void writeVarLong(long v) throws IOException {
        ExtendedIOUtil.writeVarLong((DataOutput)this.out(), (long)v);
    }

    public void writeXInt(int v) throws IOException {
        if (this.isXCompression()) {
            this.writeVarInt(v);
        } else {
            this.writeInt(v);
        }
    }

    public void writeXLong(long v) throws IOException {
        if (this.isXCompression()) {
            this.writeVarLong(v);
        } else {
            this.writeLong(v);
        }
    }

    public void writeByteArray(byte[] b) throws IOException {
        this.out().writeByteArray(b);
    }

    public void writeObject(Object object) throws IOException {
        this.out().writeObject(object);
    }

    public void writeString(String str) throws IOException {
        this.out().writeString(str);
    }

    public void writeEnum(Enum<?> literal) throws IOException {
        this.out().writeEnum(literal);
    }

    public void writeException(Throwable t) throws IOException {
        this.out().writeException(t);
    }

    public void writeCDOPackageUnit(CDOPackageUnit packageUnit, boolean withPackages) throws IOException {
        this.out().writeCDOPackageUnit(packageUnit, withPackages);
    }

    public void writeCDOPackageUnits(CDOPackageUnit ... packageUnit) throws IOException {
        this.out().writeCDOPackageUnits(packageUnit);
    }

    public void writeCDOPackageUnitType(CDOPackageUnit.Type type) throws IOException {
        this.out().writeCDOPackageUnitType(type);
    }

    public void writeCDOPackageInfo(CDOPackageInfo packageInfo) throws IOException {
        this.out().writeCDOPackageInfo(packageInfo);
    }

    public void writeCDOClassifierRef(CDOClassifierRef eClassifierRef) throws IOException {
        this.out().writeCDOClassifierRef(eClassifierRef);
    }

    public void writeCDOClassifierRef(EClassifier eClassifier) throws IOException {
        this.out().writeCDOClassifierRef(eClassifier);
    }

    public void writeCDOPackageURI(String uri) throws IOException {
        this.out().writeCDOPackageURI(uri);
    }

    public void writeCDOType(CDOType cdoType) throws IOException {
        this.out().writeCDOType(cdoType);
    }

    public void writeCDOBranch(CDOBranch branch) throws IOException {
        this.out().writeCDOBranch(branch);
    }

    public void writeCDOBranchPoint(CDOBranchPoint branchPoint) throws IOException {
        this.out().writeCDOBranchPoint(branchPoint);
    }

    public void writeCDOBranchVersion(CDOBranchVersion branchVersion) throws IOException {
        this.out().writeCDOBranchVersion(branchVersion);
    }

    public void writeCDOChangeSetData(CDOChangeSetData changeSetData) throws IOException {
        this.out().writeCDOChangeSetData(changeSetData);
    }

    public void writeCDOCommitData(CDOCommitData commitData) throws IOException {
        this.out().writeCDOCommitData(commitData);
    }

    public void writeCDOCommitInfo(CDOCommitInfo commitInfo) throws IOException {
        this.out().writeCDOCommitInfo(commitInfo);
    }

    public void writeCDOID(CDOID id) throws IOException {
        this.out().writeCDOID(id);
    }

    public void writeCDOIDReference(CDOIDReference idReference) throws IOException {
        this.out().writeCDOIDReference(idReference);
    }

    public void writeCDOIDAndVersion(CDOIDAndVersion idAndVersion) throws IOException {
        this.out().writeCDOIDAndVersion(idAndVersion);
    }

    public void writeCDOIDAndBranch(CDOIDAndBranch idAndBranch) throws IOException {
        this.out().writeCDOIDAndBranch(idAndBranch);
    }

    public void writeCDORevisionKey(CDORevisionKey revisionKey) throws IOException {
        this.out().writeCDORevisionKey(revisionKey);
    }

    public void writeCDORevision(CDORevision revision, int referenceChunk) throws IOException {
        this.out().writeCDORevision(revision, referenceChunk);
    }

    public void writeCDORevision(CDORevision revision, int referenceChunk, CDOBranchPoint securityContext) throws IOException {
        this.out().writeCDORevision(revision, referenceChunk, securityContext);
    }

    public void writeCDORevisable(CDORevisable revisable) throws IOException {
        this.out().writeCDORevisable(revisable);
    }

    public void writeCDOList(EClass owner, EStructuralFeature feature, CDOList list, int referenceChunk) throws IOException {
        this.out().writeCDOList(owner, feature, list, referenceChunk);
    }

    public void writeCDOFeatureValue(EStructuralFeature feature, Object value) throws IOException {
        this.out().writeCDOFeatureValue(feature, value);
    }

    public void writeCDORevisionDelta(CDORevisionDelta revisionDelta) throws IOException {
        this.out().writeCDORevisionDelta(revisionDelta);
    }

    public void writeCDOFeatureDelta(EClass owner, CDOFeatureDelta featureDelta) throws IOException {
        this.out().writeCDOFeatureDelta(owner, featureDelta);
    }

    public void writeCDORevisionOrPrimitive(Object value) throws IOException {
        this.out().writeCDORevisionOrPrimitive(value);
    }

    public void writeCDORevisionOrPrimitiveOrClassifier(Object value) throws IOException {
        this.out().writeCDORevisionOrPrimitiveOrClassifier(value);
    }

    public void writeCDOLockType(IRWLockManager.LockType lockType) throws IOException {
        this.out().writeCDOLockType(lockType);
    }

    public void writeCDOLockChangeInfo(CDOLockChangeInfo lockChangeInfo) throws IOException {
        this.out().writeCDOLockChangeInfo(lockChangeInfo);
    }

    public void writeCDOLockState(CDOLockState lockState) throws IOException {
        this.out().writeCDOLockState(lockState);
    }

    public void writeCDOLockOwner(CDOLockOwner lockOwner) throws IOException {
        this.out().writeCDOLockOwner(lockOwner);
    }

    public void writeCDOLockArea(IDurableLockingManager.LockArea lockArea) throws IOException {
        this.out().writeCDOLockArea(lockArea);
    }

    public int write(long startPointer, LissomeFileOperation operation) {
        try {
            this.seek(startPointer);
            operation.execute(this);
            this.flush();
            long endPointer = this.getFilePointer();
            return (int)(endPointer - startPointer);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public long append(LissomeFileOperation operation) {
        try {
            long startPointer = this.length();
            this.write(startPointer, operation);
            return startPointer;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    protected boolean isXCompression() {
        return X_COMPRESSION;
    }
}

