/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome.db;

import org.eclipse.emf.cdo.server.internal.lissome.db.Index;
import org.eclipse.emf.cdo.server.internal.lissome.db.Table;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;

public class BranchesTable
extends Table {
    protected IDBField id;
    protected IDBField name;
    protected IDBField baseBranch;
    protected IDBField baseTime;

    public BranchesTable(Index index) {
        super(index, "cdo_branches");
        this.id = this.table.addField("i", DBType.INTEGER);
        this.name = this.table.addField("n", DBType.VARCHAR, 255);
        this.baseBranch = this.table.addField("b", DBType.INTEGER);
        this.baseTime = this.table.addField("t", DBType.BIGINT);
        this.table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.id});
    }

    protected String sqlLoadSubBranches() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.id);
        builder.append(", ");
        builder.append(this.name);
        builder.append(", ");
        builder.append(this.baseTime);
        builder.append(" FROM ");
        builder.append(this);
        builder.append(" WHERE ");
        builder.append(this.baseBranch);
        builder.append("=?");
        return builder.toString();
    }

    protected String sqlLoadBranches() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.id);
        builder.append(", ");
        builder.append(this.name);
        builder.append(", ");
        builder.append(this.baseBranch);
        builder.append(", ");
        builder.append(this.baseTime);
        builder.append(" FROM ");
        builder.append(this);
        builder.append(" WHERE ");
        builder.append(this.baseBranch);
        builder.append(" BETWEEN ? AND ? ORDER BY ");
        builder.append(this.baseBranch);
        return builder.toString();
    }

    protected String sqlCreateBranch() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this);
        builder.append(" (");
        builder.append(this.id);
        builder.append(", ");
        builder.append(this.name);
        builder.append(", ");
        builder.append(this.baseBranch);
        builder.append(", ");
        builder.append(this.baseTime);
        builder.append(") VALUES (?, ?, ?, ?)");
        return builder.toString();
    }
}

