/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.impl.chart;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.device.EmptyUpdateNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.render.ActionRendererAdapter;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.mat.impl.chart.ChartBuilder;
import org.eclipse.mat.impl.chart.Messages;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultPie;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.Renderer;
import org.eclipse.mat.util.HTMLUtils;

@Renderer(target="html", result={IResultPie.class})
public class HtmlPieChartRenderer
implements IOutputter {
    public void embedd(IOutputter.Context context, IResult result, Writer writer) throws IOException {
        try {
            IResultPie pie = (IResultPie)result;
            String imageFile = "chart" + context.getId() + ".png";
            Chart chart = ChartBuilder.create(pie, false, ColorDefinitionImpl.WHITE(), ColorDefinitionImpl.BLACK());
            Trigger trigger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)200, (String)"tooltip")));
            chart.getLegend().getTriggers().add((Object)trigger);
            PluginSettings ps = PluginSettings.instance();
            IDeviceRenderer render = ps.getDevice("dv.PNG");
            render.setProperty("device.file.identifier", (Object)new File(context.getOutputDirectory(), imageFile));
            int width = 850;
            int height = 350;
            Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)width, (double)height);
            int resolution = render.getDisplayServer().getDpiResolution();
            bo.scale(72.0 / (double)resolution);
            Legend lg = chart.getLegend();
            Insets is = lg.getInsets();
            is.setLeft(is.getLeft() - 10.0);
            lg.setMaxPercent(0.4);
            RunTimeContext rtc = new RunTimeContext();
            rtc.setScriptClassLoader(new IScriptClassLoader(){

                public Class<?> loadClass(String className, ClassLoader parentLoader) throws ClassNotFoundException {
                    return this.getClass().getClassLoader().loadClass(className);
                }
            });
            Generator gr = Generator.instance();
            GeneratedChartState state = gr.build(render.getDisplayServer(), chart, bo, null, rtc, null);
            state.getRunTimeContext().setActionRenderer((IActionRenderer)new ActionRendererAdapter(){

                public void processAction(Action action, StructureSource source) {
                    if (ActionType.SHOW_TOOLTIP_LITERAL.equals((Object)action.getType())) {
                        TooltipValue tooltip = (TooltipValue)action.getValue();
                        if (StructureType.LEGEND_ENTRY.equals(source.getType())) {
                            LegendItemHints item = (LegendItemHints)source.getSource();
                            tooltip.setText(item.getItemText());
                        }
                    }
                }

                public void processAction(Action action, StructureSource source, RunTimeContext ctx) {
                    this.processAction(action, source);
                }
            });
            render.setProperty("device.component", (Object)new EmptyUpdateNotifier(chart, state.getChartModel()));
            gr.render(render, state);
            String imageMap = ((IImageMapEmitter)render).getImageMap();
            imageMap = imageMap.replaceAll("/><area", "><area").replaceFirst("/>$", ">");
            String mapName = "chart" + context.getId() + "map";
            writer.append("<map name='").append(mapName).append("'>").append(imageMap).append("</map>");
            writer.append("<img src=\"").append(imageFile).append("\" width=\"" + width + "\" height=\"" + height + "\" usemap='#").append(mapName).append("' alt=\"\">");
        }
        catch (LinkageError e) {
            this.handleError(e, writer);
        }
        catch (ChartException e) {
            this.handleError(e, writer);
        }
    }

    private void handleError(Throwable e, Writer writer) throws IOException {
        StringBuilder message = new StringBuilder();
        message.append(Messages.HtmlPieChartRenderer_ErrorRenderingChart);
        message.append(HTMLUtils.escapeText((String)e.getClass().getName()));
        if (e.getMessage() != null) {
            message.append(": ").append(HTMLUtils.escapeText((String)e.getMessage()));
        }
        String msg = message.toString();
        writer.append(msg).append(Messages.HtmlPieChartRenderer_SeeLogForDetails);
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, msg, e);
    }

    public void process(IOutputter.Context context, IResult result, Writer writer) throws IOException {
    }
}

