/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.viatra.query.runtime.base.comprehension.EMFVisitor;
import org.eclipse.viatra.query.runtime.base.core.EMFBaseIndexInstanceStore;
import org.eclipse.viatra.query.runtime.base.core.EMFBaseIndexMetaStore;
import org.eclipse.viatra.query.runtime.base.core.EMFBaseIndexStatisticsStore;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperImpl;

public abstract class NavigationHelperVisitor
extends EMFVisitor {
    protected NavigationHelperImpl navigationHelper;
    boolean isInsertion;
    boolean descendHierarchy;
    boolean traverseOnlyWellBehavingDerivedFeatures;
    EMFBaseIndexInstanceStore instanceStore;
    EMFBaseIndexStatisticsStore statsStore;
    EMFBaseIndexMetaStore metaStore;

    NavigationHelperVisitor(NavigationHelperImpl navigationHelper, boolean isInsertion, boolean descendHierarchy) {
        super(isInsertion);
        this.navigationHelper = navigationHelper;
        this.instanceStore = navigationHelper.instanceStore;
        this.metaStore = navigationHelper.metaStore;
        this.statsStore = navigationHelper.statsStore;
        this.isInsertion = isInsertion;
        this.descendHierarchy = descendHierarchy;
        this.traverseOnlyWellBehavingDerivedFeatures = navigationHelper.getBaseIndexOptions().isTraverseOnlyWellBehavingDerivedFeatures();
    }

    @Override
    public boolean pruneSubtrees(EObject source) {
        return !this.descendHierarchy;
    }

    @Override
    public boolean pruneSubtrees(Resource source) {
        return !this.descendHierarchy;
    }

    @Override
    public boolean pruneFeature(EStructuralFeature feature) {
        Object dataTypeKey;
        Object featureKey = this.toKey(feature);
        if (this.observesFeature(featureKey) || this.countsFeature(featureKey)) {
            return false;
        }
        if (feature instanceof EAttribute && (this.observesDataType(dataTypeKey = this.toKey((EClassifier)((EAttribute)feature).getEAttributeType())) || this.countsDataType(dataTypeKey))) {
            return false;
        }
        return !this.isInsertion || !this.navigationHelper.isExpansionAllowed() || !(feature instanceof EReference) || ((EReference)feature).isContainment();
    }

    protected abstract boolean observesFeature(Object var1);

    protected abstract boolean observesDataType(Object var1);

    protected abstract boolean observesClass(Object var1);

    protected abstract boolean countsFeature(Object var1);

    protected abstract boolean countsDataType(Object var1);

    protected abstract boolean countsClass(Object var1);

    @Override
    public void visitElement(EObject source) {
        Object classKey;
        EClass eClass = source.eClass();
        if (eClass.eIsProxy()) {
            eClass = (EClass)EcoreUtil.resolve((EObject)eClass, (EObject)source);
        }
        if (this.observesClass(classKey = this.toKey((EClassifier)eClass))) {
            if (this.isInsertion) {
                this.instanceStore.insertIntoInstanceSet(classKey, source);
            } else {
                this.instanceStore.removeFromInstanceSet(classKey, source);
            }
        }
        if (this.countsClass(classKey)) {
            if (this.isInsertion) {
                this.statsStore.addInstance(classKey);
            } else {
                this.statsStore.removeInstance(classKey);
            }
        }
    }

    @Override
    public void visitAttribute(EObject source, EAttribute feature, Object target) {
        Object featureKey = this.toKey((EStructuralFeature)feature);
        Object eAttributeType = this.toKey((EClassifier)feature.getEAttributeType());
        Object internalValueRepresentation = null;
        if (this.observesFeature(featureKey)) {
            internalValueRepresentation = this.metaStore.toInternalValueRepresentation(target);
            boolean unique = feature.isUnique();
            if (this.isInsertion) {
                this.instanceStore.insertFeatureTuple(featureKey, unique, internalValueRepresentation, source);
            } else {
                this.instanceStore.removeFeatureTuple(featureKey, unique, internalValueRepresentation, source);
            }
        }
        if (this.countsFeature(featureKey)) {
            if (this.isInsertion) {
                this.statsStore.addFeature(source, featureKey);
            } else {
                this.statsStore.removeFeature(source, featureKey);
            }
        }
        if (this.observesDataType(eAttributeType)) {
            if (internalValueRepresentation == null) {
                internalValueRepresentation = this.metaStore.toInternalValueRepresentation(target);
            }
            if (this.isInsertion) {
                this.instanceStore.insertIntoDataTypeMap(eAttributeType, internalValueRepresentation);
            } else {
                this.instanceStore.removeFromDataTypeMap(eAttributeType, internalValueRepresentation);
            }
        }
        if (this.countsDataType(eAttributeType)) {
            if (this.isInsertion) {
                this.statsStore.addInstance(eAttributeType);
            } else {
                this.statsStore.removeInstance(eAttributeType);
            }
        }
    }

    @Override
    public void visitInternalContainment(EObject source, EReference feature, EObject target) {
        this.visitReference(source, feature, target);
    }

    @Override
    public void visitNonContainmentReference(EObject source, EReference feature, EObject target) {
        this.visitReference(source, feature, target);
        if (this.isInsertion) {
            this.navigationHelper.considerForExpansion(target);
        }
    }

    protected void visitReference(EObject source, EReference feature, EObject target) {
        Object featureKey = this.toKey((EStructuralFeature)feature);
        if (this.observesFeature(featureKey)) {
            boolean unique = feature.isUnique();
            if (this.isInsertion) {
                this.instanceStore.insertFeatureTuple(featureKey, unique, target, source);
            } else {
                this.instanceStore.removeFeatureTuple(featureKey, unique, target, source);
            }
        }
        if (this.countsFeature(featureKey)) {
            if (this.isInsertion) {
                this.statsStore.addFeature(source, featureKey);
            } else {
                this.statsStore.removeFeature(source, featureKey);
            }
        }
    }

    @Override
    public boolean attemptProxyResolutions(EObject source, EReference feature) {
        if (this.navigationHelper.resolutionDelayingResources.isEmpty()) {
            return true;
        }
        return !this.navigationHelper.resolutionDelayingResources.contains(source.eResource());
    }

    @Override
    public void visitProxyReference(EObject source, EReference reference, EObject targetObject, Integer position) {
        if (this.isInsertion) {
            EObject touch;
            if (this.navigationHelper.isFeatureResolveIgnored((EStructuralFeature)reference)) {
                return;
            }
            if (position != null && reference.isMany() && this.attemptProxyResolutions(source, reference) && !(touch = (EObject)((List)source.eGet((EStructuralFeature)reference, true)).get(position)).eIsProxy()) {
                return;
            }
            this.navigationHelper.delayedProxyResolutions.addPairOrNop((Object)source, (Object)reference);
        }
    }

    protected Object toKey(EStructuralFeature feature) {
        return this.metaStore.toKey(feature);
    }

    protected Object toKey(EClassifier eClassifier) {
        return this.metaStore.toKey(eClassifier);
    }

    protected boolean isSampledClass(Object eClass) {
        if (!this.traverseOnlyWellBehavingDerivedFeatures) {
            EClass knownClass = (EClass)this.metaStore.getKnownClassifierForKey(eClass);
            for (EStructuralFeature feature : knownClass.getEAllStructuralFeatures()) {
                boolean visitorPrunes;
                EMFModelComprehension comprehension = this.navigationHelper.getComprehension();
                if (comprehension.untraversableDirectly(feature) || (visitorPrunes = this.pruneFeature(feature)) || !comprehension.onlySamplingFeature(feature)) continue;
                this.navigationHelper.registerEClasses(Collections.singleton(feature.getEContainingClass()), IndexingLevel.FULL);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean descendAlongCrossResourceContainments() {
        return this.navigationHelper.traversalDescendsAlongCrossResourceContainment();
    }

    public static class ChangeVisitor
    extends NavigationHelperVisitor {
        private final IndexingLevel wildcardMode;
        private final Map<Object, IndexingLevel> allObservedClasses;
        private final Map<Object, IndexingLevel> observedDataTypes;
        private final Map<Object, IndexingLevel> observedFeatures;
        private final Map<Object, Boolean> sampledClasses;

        public ChangeVisitor(NavigationHelperImpl navigationHelper, boolean isInsertion) {
            super(navigationHelper, isInsertion, false);
            this.wildcardMode = navigationHelper.getWildcardLevel();
            this.allObservedClasses = navigationHelper.getAllObservedClassesInternal();
            this.observedDataTypes = navigationHelper.getObservedDataTypesInternal();
            this.observedFeatures = navigationHelper.getObservedFeaturesInternal();
            this.sampledClasses = new HashMap<Object, Boolean>();
        }

        @Override
        protected boolean observesClass(Object eClass) {
            return this.wildcardMode.hasInstances() || IndexingLevel.FULL == this.allObservedClasses.get(eClass) || this.registerSampledClass(eClass);
        }

        protected boolean registerSampledClass(Object eClass) {
            Boolean classAlreadyChecked = this.sampledClasses.get(eClass);
            if (classAlreadyChecked != null) {
                return classAlreadyChecked;
            }
            boolean isSampledClass = this.isSampledClass(eClass);
            this.sampledClasses.put(eClass, isSampledClass);
            return false;
        }

        @Override
        protected boolean observesDataType(Object type) {
            return this.wildcardMode.hasInstances() || IndexingLevel.FULL == this.observedDataTypes.get(type);
        }

        @Override
        protected boolean observesFeature(Object feature) {
            return this.wildcardMode.hasInstances() || IndexingLevel.FULL == this.observedFeatures.get(feature);
        }

        @Override
        protected boolean countsFeature(Object feature) {
            return this.wildcardMode.hasStatistics() || this.observedFeatures.containsKey(feature) && this.observedFeatures.get(feature).hasStatistics();
        }

        @Override
        protected boolean countsDataType(Object type) {
            return this.wildcardMode.hasStatistics() || this.observedDataTypes.containsKey(type) && this.observedDataTypes.get(type).hasStatistics();
        }

        @Override
        protected boolean countsClass(Object eClass) {
            return this.wildcardMode.hasStatistics() || this.allObservedClasses.containsKey(eClass) && this.allObservedClasses.get(eClass).hasStatistics();
        }
    }

    public static class TraversingVisitor
    extends NavigationHelperVisitor {
        private final IndexingLevel wildcardMode;
        Map<Object, IndexingLevel> features;
        Map<Object, IndexingLevel> newClasses;
        Map<Object, IndexingLevel> oldClasses;
        Map<Object, IndexingLevel> classObservationMap;
        Map<Object, IndexingLevel> dataTypes;

        public TraversingVisitor(NavigationHelperImpl navigationHelper, Map<Object, IndexingLevel> features, Map<Object, IndexingLevel> newClasses, Map<Object, IndexingLevel> oldClasses, Map<Object, IndexingLevel> dataTypes) {
            super(navigationHelper, true, true);
            this.wildcardMode = navigationHelper.getWildcardLevel();
            this.features = features;
            this.newClasses = newClasses;
            this.oldClasses = oldClasses;
            this.classObservationMap = new HashMap<Object, IndexingLevel>();
            this.dataTypes = dataTypes;
        }

        protected IndexingLevel getExistingIndexingLevel(Object eClass) {
            IndexingLevel result = IndexingLevel.NONE;
            result = result.merge(this.oldClasses.get(eClass));
            if (IndexingLevel.FULL == (result = result.merge(this.oldClasses.get(this.metaStore.getEObjectClassKey())))) {
                return result;
            }
            Set<Object> superTypes = this.metaStore.getSuperTypeMap().get(eClass);
            if (superTypes != null) {
                for (Object superType : superTypes) {
                    if (IndexingLevel.FULL != (result = result.merge(this.oldClasses.get(superType)))) continue;
                    return result;
                }
            }
            return result;
        }

        protected IndexingLevel getRequestedIndexingLevel(Object eClass) {
            IndexingLevel result = IndexingLevel.NONE;
            result = result.merge(this.newClasses.get(eClass));
            if (IndexingLevel.FULL == (result = result.merge(this.newClasses.get(this.metaStore.getEObjectClassKey())))) {
                return result;
            }
            Set<Object> superTypes = this.metaStore.getSuperTypeMap().get(eClass);
            if (superTypes != null) {
                for (Object superType : superTypes) {
                    if (IndexingLevel.FULL != (result = result.merge(this.newClasses.get(superType)))) continue;
                    return result;
                }
            }
            return result;
        }

        protected IndexingLevel getTraversalIndexing(Object eClass) {
            IndexingLevel level = this.classObservationMap.get(eClass);
            if (level == null) {
                IndexingLevel requested;
                IndexingLevel existing = this.getExistingIndexingLevel(eClass);
                if (existing == (requested = this.getRequestedIndexingLevel(eClass)) || existing == IndexingLevel.FULL) {
                    return IndexingLevel.NONE;
                }
                if (requested == IndexingLevel.FULL) {
                    return IndexingLevel.FULL;
                }
                if (requested.hasStatistics() == existing.hasStatistics()) {
                    return IndexingLevel.NONE;
                }
                if (requested.hasStatistics()) {
                    return IndexingLevel.STATISTICS;
                }
                return IndexingLevel.NONE;
            }
            return level;
        }

        @Override
        protected boolean observesClass(Object eClass) {
            if (this.wildcardMode.hasInstances()) {
                return true;
            }
            return IndexingLevel.FULL == this.getTraversalIndexing(eClass);
        }

        @Override
        protected boolean countsClass(Object eClass) {
            return this.wildcardMode.hasStatistics() || this.getTraversalIndexing(eClass).hasStatistics();
        }

        @Override
        protected boolean observesDataType(Object type) {
            return this.wildcardMode.hasInstances() || IndexingLevel.FULL == this.dataTypes.get(type);
        }

        @Override
        protected boolean observesFeature(Object feature) {
            return this.wildcardMode.hasInstances() || IndexingLevel.FULL == this.features.get(feature);
        }

        @Override
        protected boolean countsDataType(Object type) {
            return this.wildcardMode.hasStatistics() || this.dataTypes.containsKey(type) && this.dataTypes.get(type).hasStatistics();
        }

        @Override
        protected boolean countsFeature(Object feature) {
            return this.wildcardMode.hasStatistics() || this.features.containsKey(feature) && this.features.get(feature).hasStatistics();
        }

        @Override
        public boolean avoidTransientContainmentLink(EObject source, EReference reference, EObject targetObject) {
            return !targetObject.eAdapters().contains((Object)this.navigationHelper.contentAdapter);
        }
    }
}

