/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.validator.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class BPELReader {
    static final String MODEL_EXTENSIONS_NAMESPACE = "http://org.eclipse.bpel.ui/";
    static final String EXTENSION_MODEL_EXTENSIONS = "bpelex";
    protected Resource processResource;
    protected Resource extensionsResource;
    protected Process process;
    protected ExtensionMap extensionMap;

    public void read(URI uri, ResourceSet resourceSet) {
        this.processResource = resourceSet.getResource(uri, true);
        this.read(this.processResource, resourceSet);
    }

    public void read(IFile modelFile, ResourceSet resourceSet) {
        URI uri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString());
        this.processResource = resourceSet.getResource(uri, true);
        this.read(this.processResource, resourceSet);
    }

    public void read(File file, ResourceSet resourceSet) {
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        this.processResource = resourceSet.getResource(uri, true);
        this.read(this.processResource, resourceSet);
    }

    public void read(URL file, ResourceSet resourceSet) {
        URI uri = URI.createURI((String)file.toString());
        this.processResource = resourceSet.getResource(uri, true);
        this.read(this.processResource, resourceSet);
    }

    public void read(Resource resource, ResourceSet resourceSet) {
        this.processResource = resource;
        this.process = null;
        try {
            this.processResource.load(Collections.EMPTY_MAP);
            EList contents = this.processResource.getContents();
            if (!contents.isEmpty()) {
                this.process = (Process)contents.get(0);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    void readExtensions(Resource resource, ResourceSet resourceSet, File modelFile) {
    }

    void readExtensions(Resource resource, ResourceSet resourceSet, IFile modelFile) {
    }

    public ExtensionMap getExtensionMap() {
        return this.extensionMap;
    }

    public Resource getExtensionsResource() {
        return this.extensionsResource;
    }

    public Process getProcess() {
        return this.process;
    }

    public Resource getProcessResource() {
        return this.processResource;
    }
}

