/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IConstants;
import org.eclipse.bpel.validator.model.IModelQuery;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.IValue;
import org.eclipse.bpel.validator.model.Problem;
import org.eclipse.bpel.validator.model.RuleRunner;
import org.eclipse.bpel.validator.model.Rules;
import org.eclipse.bpel.validator.model.Selector;

public class Validator
implements IConstants {
    Logger mLogger = Logger.getLogger(this.getClass().getName());
    RuleRunner fRuleRunner;
    private List<IProblem> fProblems = new ArrayList<IProblem>(4);
    static final IProblem[] EMPTY_ARRAY = new IProblem[0];
    protected INode mNode;
    protected IModelQuery mModelQuery;
    private Map<Object, Object> mData = new HashMap<Object, Object>(5);
    protected static Selector mSelector = new Selector();
    public static final String PASS1 = "pass1";
    public static final String PASS2 = "pass2";
    private Validator fNext = null;
    private Validator fPrev = null;
    private Set<ARule> mSAChecks = null;

    protected Validator() {
        this.fRuleRunner = new RuleRunner(this);
    }

    public void setNode(INode node) {
        this.mNode = node;
    }

    public void setModelQuery(IModelQuery query) {
        this.mModelQuery = query;
    }

    public void setSAChecks(Set<ARule> ruleSet) {
        this.mSAChecks = ruleSet;
    }

    protected void attach(Validator next) {
        if (this == next) {
            return;
        }
        if (this.fNext == null) {
            this.fNext = next;
            next.fNext = null;
            next.fPrev = this;
        } else {
            this.fNext.attach(next);
        }
    }

    public final void validate(String tag) {
        try {
            if (tag.equals(PASS1)) {
                this.start();
            }
            this.fRuleRunner.runRules(tag, new Object[0]);
            if (tag.equals(PASS2)) {
                this.end();
            }
        }
        catch (Throwable t) {
            this.mLogger.logp(Level.SEVERE, this.getClass().getName(), "validate", "Problem executing this validator.", t);
        }
        if (this.fNext != null) {
            this.fNext.validate(tag);
        }
    }

    public final IProblem[] getProblems() {
        if (this.fProblems.size() == 0) {
            return EMPTY_ARRAY;
        }
        return this.fProblems.toArray(EMPTY_ARRAY);
    }

    public boolean hasProblems() {
        return !this.fProblems.isEmpty();
    }

    public boolean hasProblems(INode node) {
        if (this.isDefined(node)) {
            Validator validator = node.nodeValidator();
            if (validator != null) {
                return validator.hasProblems();
            }
            return false;
        }
        return true;
    }

    protected void disableRules() {
        this.disableRules(0, 65536);
    }

    protected void disableRules(int startIdx, int endIdx) {
        this.fRuleRunner.addFilter(new Rules.IndexFilter(startIdx, endIdx));
    }

    protected void start() {
        this.fRuleRunner.start();
        if (this.fPrev == null) {
            this.fProblems.clear();
            this.mData.clear();
        } else {
            Validator first = this.getFirst();
            this.fProblems = first.fProblems;
            this.mData = first.mData;
            this.mNode = first.mNode;
            this.mModelQuery = first.mModelQuery;
            this.mSAChecks = first.mSAChecks;
        }
    }

    protected void end() {
    }

    protected void runRules(String tag, Object ... args) {
        this.fRuleRunner.runRules(tag, args);
    }

    protected void addProblems(IProblem[] problems) {
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem p = iProblemArray[n2];
            this.fProblems.add(p);
            ++n2;
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Internal error: no validator.", date="10/2/2006", sa=-1, warnings="BPELC__INTERNAL")
    protected void internalProblem(Rules.Rule rule, Throwable t) {
        IProblem problem = this.createWarning();
        while (t.getCause() != null) {
            t = t.getCause();
        }
        problem.fill("BPELC__INTERNAL", this.toString(this.mNode.nodeName()), rule.getFullName(), rule.getIndex(), rule.getTag(), t);
        problem.setAttribute("exception", t);
    }

    protected void markSAExecution(ARule arule) {
        if (this.mSAChecks == null) {
            return;
        }
        if (arule == null) {
            arule = this.fRuleRunner.getExecutingRule().method.getAnnotation(ARule.class);
        }
        if (arule != null) {
            this.mSAChecks.add(arule);
        }
    }

    public void adopt(IProblem problem, INode node) {
        this.fProblems.add(problem);
        problem.setAttribute("node", node);
        problem.setAttribute("lineNumber", this.mModelQuery.lookup(node, 0, -1));
        problem.setAttribute("columnNumber", this.mModelQuery.lookup(node, 1, -1));
        problem.setAttribute("charEnd", this.mModelQuery.lookup(node, 3, -1));
        problem.setAttribute("charStart", this.mModelQuery.lookup(node, 2, -1));
        problem.setAttribute("location", this.mModelQuery.lookup(node, 3, null, null));
        problem.setAttribute("address.model", this.mModelQuery.lookup(node, 5, null, null));
        problem.setAttribute("address.xpath", this.mModelQuery.lookup(node, 6, null, null));
    }

    protected IProblem createProblem(INode node) {
        Problem problem = new Problem(this);
        this.adopt(problem, node);
        Rules.Rule r = this.fRuleRunner.getExecutingRule();
        if (r != null) {
            problem.setAttribute("ruleName", r.getFullName());
            ARule a = r.method.getAnnotation(ARule.class);
            if (a != null) {
                this.markSAExecution(a);
                problem.setAttribute("staticAnalysisCode", a.sa());
                problem.setAttribute("ruleDescription", a.desc());
            }
        }
        return problem;
    }

    protected IProblem createError() {
        return this.createError(this.mNode);
    }

    protected IProblem createError(INode node) {
        IProblem problem = this.createProblem(node);
        problem.setAttribute("severity", 2);
        return problem;
    }

    protected IProblem createWarning() {
        return this.createWarning(this.mNode);
    }

    protected IProblem createWarning(INode node) {
        IProblem problem = this.createProblem(node);
        problem.setAttribute("severity", 1);
        return problem;
    }

    protected IProblem createInfo(INode node) {
        IProblem problem = this.createProblem(node);
        problem.setAttribute("severity", 0);
        return problem;
    }

    protected IProblem createInfo() {
        return this.createInfo(this.mNode);
    }

    protected boolean isDefined(INode node) {
        return node != null && node.isResolved();
    }

    protected boolean isUndefined(INode node) {
        return node == null || !node.isResolved();
    }

    public <T> T getValue(Object key) {
        return this.getValue(key, null);
    }

    public <T> T getValue(Object key, T def) {
        if (this.mData.containsKey(key)) {
            Object obj = this.mData.get(key);
            if (obj instanceof IValue) {
                return ((IValue)obj).get();
            }
            return (T)obj;
        }
        return def;
    }

    public <T> T getValue(INode node, Object key, T def) {
        Validator validator = this.validatorForNode(node);
        if (validator != null) {
            return validator.getValue(key, def);
        }
        return def;
    }

    public <T> T setValue(Object keyName, T value) {
        return (T)this.mData.put(keyName, value);
    }

    public <T> T setValue(INode node, Object keyName, T value) {
        Validator validator = this.validatorForNode(node);
        if (validator != null) {
            return validator.setValue(keyName, value);
        }
        return null;
    }

    public boolean containsValueKey(String key) {
        return this.mData.containsKey(key);
    }

    public boolean containsValueKey(INode node, String key) {
        Validator validator = this.validatorForNode(node);
        return validator != null ? validator.containsValueKey(key) : false;
    }

    Validator validatorForNode(INode node) {
        if (this.isDefined(node)) {
            return node.nodeValidator();
        }
        return null;
    }

    private Validator getFirst() {
        Validator first = this;
        while (first.fPrev != null) {
            first = first.fPrev;
        }
        return first;
    }

    protected String toString(QName qname) {
        if (Validator.isEmptyOrWhitespace(qname.getNamespaceURI())) {
            return qname.getLocalPart();
        }
        StringBuilder sb = new StringBuilder(32);
        String prefix = qname.getPrefix();
        if (Validator.isEmptyOrWhitespace(prefix)) {
            prefix = this.mModelQuery.lookup(this.mNode, 1, qname.getNamespaceURI(), null);
        }
        if (prefix == null) {
            return qname.toString();
        }
        return sb.append(prefix).append(":").append(qname.getLocalPart()).toString();
    }

    public static boolean isEmptyOrWhitespace(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        int i = 0;
        int j = value.length();
        while (i < j) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNonEmpty(String value) {
        return value != null && value.length() > 0;
    }
}

