/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.IFactory;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.bpel.validator.rules.UnknownElementValidator;

public class Factory
implements IFactory<Validator> {
    static final String PACKAGE_NAME = Factory.class.getPackage().getName();
    public static final IFactory<Validator> INSTANCE = new Factory();
    Logger mLogger = Logger.getLogger(this.getClass().getName());

    @Override
    public Validator create(QName qname) {
        String nsURI = qname.getNamespaceURI();
        if (nsURI.equals("http://docs.oasis-open.org/wsbpel/2.0/process/executable") || nsURI.equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/")) {
            Validator validator = this.createValidator(qname.getLocalPart());
            if (validator == null) {
                validator = new UnknownElementValidator();
            }
            return validator;
        }
        return null;
    }

    Validator createValidator(String nodeName) {
        Object obj;
        Class<?> clazz;
        String name = String.valueOf(Character.toUpperCase(nodeName.charAt(0))) + nodeName.substring(1);
        String validatorClass = String.valueOf(PACKAGE_NAME) + "." + name + "Validator";
        try {
            clazz = Class.forName(validatorClass);
        }
        catch (Throwable t) {
            this.mLogger.log(Level.FINE, "Validator not found in this factory {0}", t.getMessage());
            return null;
        }
        try {
            obj = clazz.newInstance();
        }
        catch (Throwable t) {
            this.mLogger.log(Level.WARNING, "Validator class cannot be created.", t);
            return null;
        }
        if (obj instanceof Validator) {
            return (Validator)obj;
        }
        this.mLogger.log(Level.WARNING, "Object is {0} is not a validator", obj);
        return null;
    }
}

