/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.Map;
import java.util.Set;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;
import org.eclipse.bpel.validator.rules.FlowValidator;

public class TargetValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_TARGETS);
    String ncName;
    protected INode fFlowNode;
    protected Set<String> fSet;
    protected Map<String, INode> fTargetMap;
    protected INode fRepeatableConstructNode;
    protected INode fEventHanderNode;

    @Override
    protected void start() {
        super.start();
        this.ncName = this.mNode.getAttribute(AT_LINK_NAME);
    }

    @ARule(date="9/14/2006", desc="Check the target variable NCName", author="michal.chmielewski@oracle.com", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckName_1() {
        this.checkNCName(this.mNode, this.ncName, AT_LINK_NAME);
    }

    @ARule(sa=1200, desc="Check if we are within a flow, if not disable rest of rules", author="michal.chmielewski@oracle.com", date="02/17/2007")
    public void rule_CheckIfInFlow_2() {
        this.fFlowNode = mSelector.selectParent(this.mNode, Filters.FLOW);
        if (this.isUndefined(this.fFlowNode)) {
            this.disableRules(10, 1000);
            return;
        }
        this.fSet = this.getValue(this.fFlowNode, FlowValidator.LINKS_SET, null);
    }

    @ARule(sa=65, desc="The value of the linkName attribute of <target> MUST be the name of a <link> declared in an enclosing <flow> activity.", author="michal.chmielewski@oracle.com", date="02/16/2007", errors="BPELC_LINK__UNDEFINED")
    public void rule_CheckAgainstDeclaredLink_12() {
        if (this.fSet == null) {
            return;
        }
        if (!this.fSet.contains(this.ncName)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_LINK__UNDEFINED", this.toString(this.mNode.nodeName()), this.ncName);
        }
    }

    @ARule(sa=66, desc="Every link must have exactly one activity as source and one as target", author="michal.chmielewski@oracle.com", date="02/17/2007", errors="BPELC_LINK__NAME_USED")
    public void rule_CheckIfSourceAlreadyUsed_12() {
        this.fTargetMap = this.getValue(this.fFlowNode, FlowValidator.TARGET_MAP, null);
        if (this.fTargetMap.containsKey(this.ncName)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_LINK__NAME_USED", this.toString(this.mNode.nodeName()), this.ncName);
            return;
        }
        this.fTargetMap.put(this.ncName, this.mNode.parentNode().parentNode());
    }
}

