/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.xpath;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.xpath.XPathValidator;
import org.eclipse.bpel.xpath10.Expr;
import org.eclipse.bpel.xpath10.FunctionCallExpr;
import org.eclipse.bpel.xpath10.LocationPath;
import org.eclipse.bpel.xpath10.UnaryExpr;
import org.eclipse.bpel.xpath10.VariableReferenceExpr;

public class Query
extends XPathValidator {
    boolean bBpelFunctions = true;
    boolean bBpelVariables = false;

    @Override
    public void start() {
        super.start();
        this.bBpelFunctions = this.getValue("bpel.function", this.bBpelFunctions);
        this.bBpelVariables = this.getValue("bpel.variables", this.bBpelVariables);
    }

    @ARule(sa=27, desc="Check the query location path", author="michal.chmielewski@oracle.com", date="01/20/2007", order=16)
    public void CheckQuery() {
        Expr expr = this.xpathExpr;
        if (expr instanceof UnaryExpr && ((UnaryExpr)expr).getExpr() instanceof LocationPath) {
            expr = ((UnaryExpr)expr).getExpr();
            Object obj = this.mVisitor.contextPeek();
            if (obj instanceof INode) {
                this.mVisitor.visit(expr);
            } else {
                IProblem problem = this.createError();
                problem.fill("XPATH_NO_LOCATION_PATH", expr.getText(), this.toString(this.mNode.nodeName()));
                this.repointOffsets(problem, expr);
            }
        } else {
            IProblem problem = this.createError();
            problem.fill("XPATH_NOT_A_LOCATION", this.exprStringTrimmed, this.toString(this.mNode.nodeName()));
            this.repointOffsets(problem, expr);
        }
        this.disableRules();
    }

    @ARule(sa=27, desc="There is no implicit context node in XPath expressions used in BPEL", author="michal.chmielewski@oracle.com", date="0/20/2007", tag="location")
    public void CheckLocationPath(LocationPath expr) {
        Object obj = this.mVisitor.contextPeek();
        if (obj instanceof INode) {
            return;
        }
        IProblem problem = this.createError();
        problem.fill("XPATH_NO_LOCATION_PATH", expr.getText(), this.toString(this.mNode.nodeName()));
        this.repointOffsets(problem, (Expr)expr);
        this.disableRules();
    }

    @ARule(sa=29, desc="BPEL variables cannot be used in propertyAlias queries", author="michal.chmielewski@oracle.com", date="01/30/2007", tag="variables")
    public void CheckVariable(VariableReferenceExpr expr) {
        if (this.bBpelVariables) {
            return;
        }
    }

    @ARule(sa=29, desc="BPEL Functions must not be used in query expressions for propertyAlias", author="michal.chmielewski@oracle.com", date="01/20/2007", tag="bpel.functions")
    public void CheckBPELFunctions(FunctionCallExpr expr) {
        if (this.bBpelFunctions) {
            return;
        }
        IProblem problem = this.createError();
        problem.fill("XPATH_BPEL_FUNCTION", this.toString(this.mNode.nodeName()), expr.getFunctionName(), this.fExprByNode);
        this.repointOffsets(problem, (Expr)expr);
    }
}

