/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigInfoFactory2;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public final class ScannerConfigProfileManager {
    public static final String SI_PROFILE_SIMPLE_ID = "ScannerConfigurationDiscoveryProfile";
    public static final String PER_PROJECT_PROFILE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".GCCStandardMakePerProjectProfile";
    public static final String NULL_PROFILE_ID = "";
    public static final String DEFAULT_SI_PROFILE_ID = "";
    private final Map<IProject, Map<InfoContext, Object>> projectToProfileInstanceMap;
    private List<String> profileIds;
    private List<String> contextAwareProfileIds;
    private final Object fLock = new Object();
    private static final ScannerConfigProfileManager instance = new ScannerConfigProfileManager();

    private ScannerConfigProfileManager() {
        this.projectToProfileInstanceMap = new HashMap<IProject, Map<InfoContext, Object>>();
    }

    public static ScannerConfigProfileManager getInstance() {
        return instance;
    }

    private String getProfileId(IProject project, InfoContext context) {
        String profileId;
        try {
            IScannerConfigBuilderInfo2Set container = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set(project);
            IScannerConfigBuilderInfo2 buildInfo = container.getInfo(context);
            if (buildInfo == null) {
                buildInfo = container.getInfo(new InfoContext(project));
            }
            profileId = buildInfo.getSelectedProfileId();
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
            profileId = "";
        }
        return profileId;
    }

    public void addProfile(IProject project, ScannerConfigProfile profile) {
        this.addProfile(project, new InfoContext(project), profile);
    }

    public void addProfile(IProject project, InfoContext context, ScannerConfigProfile profile) {
        this.getProfileMap(project, true).put(context, profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<InfoContext, Object> getProfileMap(IProject project, boolean create) {
        Object object = this.fLock;
        synchronized (object) {
            Map<InfoContext, Object> map = this.projectToProfileInstanceMap.get(project);
            if (map == null && create) {
                map = new HashMap<InfoContext, Object>();
                this.projectToProfileInstanceMap.put(project, map);
            }
            return Collections.synchronizedMap(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleProjectRemoved(IProject project) {
        Object object = this.fLock;
        synchronized (object) {
            this.projectToProfileInstanceMap.remove(project);
        }
    }

    public SCProfileInstance getSCProfileInstance(IProject project, String profileId) {
        return this.getSCProfileInstance(project, new InfoContext(project), profileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCProfileInstance getSCProfileInstance(IProject project, InfoContext context, String profileId) {
        if (profileId == "") {
            profileId = this.getProfileId(project, context);
        }
        Object object = this.fLock;
        synchronized (object) {
            SCProfileInstance profileInstance;
            Map<InfoContext, Object> map = this.getProfileMap(project, true);
            SoftReference profileInstanceReference = (SoftReference)map.get(context);
            SCProfileInstance sCProfileInstance = profileInstance = profileInstanceReference != null ? (SCProfileInstance)profileInstanceReference.get() : null;
            if (profileInstance == null || !profileInstance.getProfile().getId().equals(profileId)) {
                profileInstance = new SCProfileInstance(project, context, this.getSCProfileConfiguration(profileId));
                map.put(context, new SoftReference<SCProfileInstance>(profileInstance));
            }
            return profileInstance;
        }
    }

    public SCProfileInstance getSCProfileInstance(String profileId) {
        SCProfileInstance profileInstance = null;
        if (profileId != "") {
            profileInstance = new SCProfileInstance(null, this.getSCProfileConfiguration(profileId));
        }
        return profileInstance;
    }

    public ScannerConfigProfile getSCProfileConfiguration(String profileId) {
        profileId = profileId == "" ? ScannerConfigProfileManager.getDefaultSIProfileId() : profileId;
        return new ScannerConfigProfile(profileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getProfileIds() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.profileIds == null) {
                this.profileIds = new ArrayList<String>();
                IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.make.core", SI_PROFILE_SIMPLE_ID);
                if (extension != null) {
                    IExtension[] extensions = extension.getExtensions();
                    int i = 0;
                    while (i < extensions.length) {
                        String rProfileId = extensions[i].getUniqueIdentifier();
                        this.profileIds.add(rProfileId);
                        ++i;
                    }
                }
            }
        }
        return Collections.unmodifiableList(this.profileIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getProfileIds(InfoContext context) {
        if (context.isDefaultContext() || context.getProject() == null) {
            return this.getProfileIds();
        }
        Object object = this.fLock;
        synchronized (object) {
            if (this.contextAwareProfileIds == null) {
                this.contextAwareProfileIds = new ArrayList<String>();
                List<String> all = this.getProfileIds();
                int i = 0;
                while (i < all.size()) {
                    String id = all.get(i);
                    ScannerConfigProfile profile = this.getSCProfileConfiguration(id);
                    if (profile.supportsContext()) {
                        this.contextAwareProfileIds.add(id);
                    }
                    ++i;
                }
            }
        }
        return Collections.unmodifiableList(this.contextAwareProfileIds);
    }

    public static String getDefaultSIProfileId() {
        return "";
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(IProject project, String profileId) throws CoreException {
        return ScannerConfigInfoFactory2.create(project, profileId);
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(IProject project) throws CoreException {
        return ScannerConfigInfoFactory2.create(project, "");
    }

    public static IScannerConfigBuilderInfo2Set createScannerConfigBuildInfo2Set(IProject project) throws CoreException {
        return ScannerConfigInfoFactory2.createInfoSet(project, "");
    }

    public static IScannerConfigBuilderInfo2Set createScannerConfigBuildInfo2Set(IProject project, String profileId) throws CoreException {
        return ScannerConfigInfoFactory2.createInfoSet(project, profileId);
    }

    public static IScannerConfigBuilderInfo2Set createScannerConfigBuildInfo2Set(Preferences prefs, boolean useDefaults) throws CoreException {
        return ScannerConfigInfoFactory2.createInfoSet(prefs, "", useDefaults);
    }

    public static IScannerConfigBuilderInfo2Set createScannerConfigBuildInfo2Set(Preferences prefs, String profileId, boolean useDefaults) throws CoreException {
        return ScannerConfigInfoFactory2.createInfoSet(prefs, profileId, useDefaults);
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(Preferences prefs, String profileId, boolean useDefaults) {
        return ScannerConfigInfoFactory2.create(prefs, profileId, useDefaults);
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(Preferences prefs, boolean useDefaults) {
        return ScannerConfigInfoFactory2.create(prefs, "", useDefaults);
    }
}

