/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.listener.IEventListener;

public abstract class BaseAWTEventListener
implements IEventListener {
    private static AutServerLogger log = new AutServerLogger(BaseAWTEventListener.class);

    protected Component getEventSource(AWTEvent event) {
        Component result = null;
        Object source = event.getSource();
        if (log.isDebugEnabled()) {
            log.debug((Object)("source:" + source.toString()));
        }
        if (source instanceof JPopupMenu) {
            result = ((JPopupMenu)source).getInvoker();
        } else if (source instanceof Component) {
            MouseEvent ev;
            Component mouseOn;
            result = (Component)source;
            if (event instanceof MouseEvent && (mouseOn = SwingUtilities.getDeepestComponentAt(result, (ev = (MouseEvent)event).getX(), ev.getY())) != null) {
                result = mouseOn;
            }
        }
        return result;
    }

    protected static Class getComponentClass(Component component) {
        return component == null ? null : component.getClass();
    }
}

