/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.IBMDumpProvider;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IBMHeapDumpProvider
extends IBMDumpProvider {
    IBMHeapDumpProvider() {
    }

    @Override
    String dumpName() {
        return "heapdump.YYmmdd.HHMMSS.%pid%.seq.phd";
    }

    @Override
    int files() {
        return 2;
    }

    @Override
    long averageFileSize(Collection<File> files) {
        long l1 = 0L;
        int i1 = 0;
        long l2 = 0L;
        int i2 = 0;
        for (File f : files) {
            if (!f.isFile()) continue;
            String s = f.getName();
            if (s.endsWith(".phd")) {
                l1 += f.length();
                ++i1;
                continue;
            }
            if (!s.endsWith(".txt")) continue;
            l2 += f.length();
            ++i2;
        }
        if (i1 > 0 && i2 > 0) {
            return (l1 / (long)i1 + l2 / (long)i2) / 2L;
        }
        if (i1 > 0) {
            return l1 / (long)i1;
        }
        if (i2 > 0) {
            return l2 / (long)i2;
        }
        return 10000000L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File jextract(File preferredDump, boolean compress, List<File> dumps, File udir, File javahome, IProgressListener listener) throws IOException, InterruptedException, SnapshotException {
        block20: {
            result = this.mergeFileNames(preferredDump, dumps.get(0));
            if (compress && !result.getName().endsWith(".gz")) {
                result = new File(String.valueOf(result.getPath()) + ".gz");
            }
            var9_8 = dumps.iterator();
            do {
                if (var9_8.hasNext()) continue;
                zip = result.getName().endsWith(".gz");
                if (!zip) break block20;
                listener.subTask(Messages.getString("IBMDumpProvider.CompressingDump"));
                bufsize = 65536;
                is = new BufferedInputStream(new FileInputStream(dumps.get(0)), bufsize);
                ** try [egrp 0[TRYBLOCK] [2, 4 : 201->247)] { 
lbl13:
                // 1 sources

                ** GOTO lbl-1000
            } while ((name = (dump = var9_8.next()).getName()).contains("heapdump") || name.contains("javacore"));
            return super.jextract(preferredDump, compress, dumps, udir, javahome, listener);
lbl-1000:
            // 1 sources

            {
                os = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(result)));
                buffer = new byte[bufsize];
lbl19:
                // 2 sources

                while (true) {
                    if (listener.isCanceled()) {
                    }
                    ** GOTO lbl28
                    break;
                }
                {
                    block21: {
                        catch (Throwable var14_20) {
                            os.close();
                            throw var14_20;
                        }
                        os.close();
                        return null;
lbl28:
                        // 1 sources

                        ** try [egrp 3[TRYBLOCK] [3 : 254->299)] { 
lbl-1000:
                        // 1 sources

                        {
                            r = is.read(buffer);
                            if (r <= 0) break block21;
                            os.write(buffer, 0, r);
                            ** continue;
                        }
                    }
                    os.close();
                    break block20;
                }
            }
lbl36:
            // 2 sources

            catch (IOException e) {
                var16_23 = super.jextract(preferredDump, compress, dumps, udir, javahome, listener);
                return var16_23;
            }
lbl39:
            // 1 sources

            finally {
                is.close();
            }
        }
        renamed = 0;
        v0 = i = zip != false ? 1 : 0;
        while (true) {
            if (i >= dumps.size()) {
                if (zip == false) return result;
                dumps.get(0).delete();
                return result;
            }
            dump = dumps.get(i);
            if (i == 0) {
                dest = result;
            } else {
                name1 = result.getName();
                name2 = dumps.get(i).getName();
                e1 = name1.lastIndexOf(46);
                e2 = name2.lastIndexOf(46);
                name = e1 >= 0 && e2 >= 0 ? String.valueOf(name1.substring(0, e1)) + name2.substring(e2) : name2;
                dest = new File(result.getParentFile(), name);
            }
            rn = dump.renameTo(dest);
            if (rn) {
                ++renamed;
            } else if (renamed == 0) {
                return super.jextract(preferredDump, compress, dumps, udir, javahome, listener);
            }
            ++i;
        }
    }
}

