/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.lock;

import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public interface IDurableLockingManager {
    public LockArea createLockArea(String var1, CDOBranchPoint var2, boolean var3, Map<CDOID, LockGrade> var4) throws LockAreaAlreadyExistsException;

    public LockArea getLockArea(String var1) throws LockAreaNotFoundException;

    public void getLockAreas(String var1, LockArea.Handler var2);

    public void deleteLockArea(String var1);

    public static interface LockArea
    extends CDOBranchPoint {
        public static final int DEFAULT_DURABLE_LOCKING_ID_BYTES = 32;

        public String getDurableLockingID();

        public String getUserID();

        public boolean isReadOnly();

        public Map<CDOID, LockGrade> getLocks();

        public boolean isMissing();

        @FunctionalInterface
        public static interface Handler {
            public boolean handleLockArea(LockArea var1);
        }
    }

    public static class LockAreaAlreadyExistsException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;
        private String durableLockingID;

        public LockAreaAlreadyExistsException(String durableLockingID) {
            super("A lock area with ID=" + durableLockingID + " already exists");
            this.durableLockingID = durableLockingID;
        }

        public String getDurableLockingID() {
            return this.durableLockingID;
        }
    }

    public static class LockAreaNotFoundException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;
        private String durableLockingID;

        public LockAreaNotFoundException(String durableLockingID) {
            super("No lock area for ID=" + durableLockingID);
            this.durableLockingID = durableLockingID;
        }

        public LockAreaNotFoundException(String message, Throwable cause, String durableLockingID) {
            super(message, cause);
            this.durableLockingID = durableLockingID;
        }

        public String getDurableLockingID() {
            return this.durableLockingID;
        }
    }

    public static enum LockGrade {
        NONE(0),
        READ(1),
        WRITE(2),
        READ_WRITE(READ.getValue() | WRITE.getValue()),
        OPTION(4),
        READ_OPTION(READ.getValue() | OPTION.getValue()),
        WRITE_OPTION(WRITE.getValue() | OPTION.getValue()),
        READ_WRITE_OPTION(READ.getValue() | WRITE.getValue() | OPTION.getValue());

        private final int value;

        private LockGrade(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isRead() {
            return (this.value & 1) != 0;
        }

        public boolean isWrite() {
            return (this.value & 2) != 0;
        }

        public boolean isOption() {
            return (this.value & 4) != 0;
        }

        public LockGrade getUpdated(IRWLockManager.LockType type, boolean on) {
            int mask = this.getMask(type);
            if (on) {
                return LockGrade.get(this.value | mask);
            }
            return LockGrade.get(this.value & ~mask);
        }

        private int getMask(IRWLockManager.LockType type) {
            switch (type) {
                case READ: {
                    return 1;
                }
                case WRITE: {
                    return 2;
                }
                case OPTION: {
                    return 4;
                }
            }
            return 0;
        }

        public static LockGrade get(IRWLockManager.LockType type) {
            if (type == IRWLockManager.LockType.READ) {
                return READ;
            }
            if (type == IRWLockManager.LockType.WRITE) {
                return WRITE;
            }
            if (type == IRWLockManager.LockType.OPTION) {
                return OPTION;
            }
            return NONE;
        }

        @Deprecated
        public static LockGrade get(boolean read, boolean write) {
            return LockGrade.get((read ? 1 : 0) | (write ? 2 : 0));
        }

        public static LockGrade get(boolean read, boolean write, boolean option) {
            return LockGrade.get((read ? 1 : 0) | (write ? 2 : 0) | (option ? 4 : 0));
        }

        public static LockGrade get(int value) {
            switch (value) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return READ;
                }
                case 2: {
                    return WRITE;
                }
                case 3: {
                    return READ_WRITE;
                }
                case 4: {
                    return OPTION;
                }
                case 5: {
                    return READ_OPTION;
                }
                case 6: {
                    return WRITE_OPTION;
                }
                case 7: {
                    return READ_WRITE_OPTION;
                }
            }
            throw new IllegalArgumentException("Invalid lock grade: " + value);
        }
    }
}

