/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.java.ASTNode;
import org.eclipse.modisco.java.AbstractMethodDeclaration;
import org.eclipse.modisco.java.AbstractTypeDeclaration;
import org.eclipse.modisco.java.AnnotationTypeMemberDeclaration;
import org.eclipse.modisco.java.AnonymousClassDeclaration;
import org.eclipse.modisco.java.ArrayType;
import org.eclipse.modisco.java.BodyDeclaration;
import org.eclipse.modisco.java.CatchClause;
import org.eclipse.modisco.java.EnumConstantDeclaration;
import org.eclipse.modisco.java.EnumDeclaration;
import org.eclipse.modisco.java.FieldDeclaration;
import org.eclipse.modisco.java.Initializer;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.NamedElement;
import org.eclipse.modisco.java.Package;
import org.eclipse.modisco.java.ParameterizedType;
import org.eclipse.modisco.java.PrimitiveType;
import org.eclipse.modisco.java.SingleVariableDeclaration;
import org.eclipse.modisco.java.Type;
import org.eclipse.modisco.java.TypeAccess;
import org.eclipse.modisco.java.TypeParameter;
import org.eclipse.modisco.java.UnresolvedItem;
import org.eclipse.modisco.java.VariableDeclarationFragment;
import org.eclipse.modisco.java.WildCardType;
import org.eclipse.modisco.java.plugin.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaUtil {
    private static final String TRACEID_GETQNAME = "org.eclipse.modisco.java/debug/JavaUtil/getQualifiedNames";
    private static final boolean TRACE_GETQNAME = JavaPlugin.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.modisco.java/debug/JavaUtil/getQualifiedNames")) != false;
    private static final String TRACEID_NE_BY_QN = "org.eclipse.modisco.java/debug/JavaUtil/getNamedElementByQualifiedName";
    private static final boolean TRACE_NE_BY_QN = JavaPlugin.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.modisco.java/debug/JavaUtil/getNamedElementByQualifiedName")) != false;

    private JavaUtil() {
    }

    public static String getQualifiedName(ASTNode object) {
        return JavaUtil.getQualifiedName(object, true);
    }

    public static String getQualifiedName(ASTNode object, boolean removeGenerics) {
        StringBuilder buffer = new StringBuilder();
        if (object instanceof UnresolvedItem) {
            buffer.append(((UnresolvedItem)object).getName());
        } else if (object instanceof AnnotationTypeMemberDeclaration) {
            String containerQName = JavaUtil.getQualifiedName((ASTNode)object.eContainer(), removeGenerics);
            buffer.append(containerQName);
            buffer.append(".");
            buffer.append(((AnnotationTypeMemberDeclaration)object).getName());
            buffer.append("()");
        } else if (object instanceof EnumConstantDeclaration) {
            String containerQName = JavaUtil.getQualifiedName((ASTNode)object.eContainer(), removeGenerics);
            buffer.append(containerQName);
            buffer.append(".");
            buffer.append(((EnumConstantDeclaration)object).getName());
        } else if (object instanceof VariableDeclarationFragment) {
            if (object.eContainer() instanceof FieldDeclaration) {
                VariableDeclarationFragment singleVariableDeclaration = (VariableDeclarationFragment)object;
                String containerQN = JavaUtil.getQualifiedName((ASTNode)singleVariableDeclaration.eContainer().eContainer(), removeGenerics);
                buffer.append(containerQN);
                buffer.append(".");
                buffer.append(singleVariableDeclaration.getName());
            }
        } else if (object instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration methodDeclaration = (AbstractMethodDeclaration)object;
            String containerQName = JavaUtil.getQualifiedName((ASTNode)object.eContainer(), removeGenerics);
            buffer.append(containerQName);
            buffer.append('.');
            buffer.append(methodDeclaration.getName());
            buffer.append('(');
            int i = 0;
            while (i < methodDeclaration.getParameters().size()) {
                if (i > 0) {
                    buffer.append(",");
                }
                SingleVariableDeclaration svd = (SingleVariableDeclaration)methodDeclaration.getParameters().get(i);
                buffer.append(JavaUtil.getQualifiedName(svd.getType(), true));
                ++i;
            }
            buffer.append(")");
        } else if (object instanceof ArrayType) {
            ArrayType arraytype = (ArrayType)object;
            buffer.append(arraytype.getName());
        } else if (object instanceof TypeParameter) {
            TypeParameter typeParameter = (TypeParameter)object;
            if (removeGenerics) {
                if (typeParameter.getBounds().size() > 0) {
                    buffer.append(JavaUtil.getQualifiedName((ASTNode)typeParameter.getBounds().get(0), true));
                } else {
                    buffer.append("java.lang.Object");
                }
            } else {
                buffer.append(typeParameter.getName());
            }
        } else if (object instanceof WildCardType) {
            WildCardType wildcardType = (WildCardType)object;
            buffer.append(wildcardType.getName());
        } else if (object instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)object;
            if (removeGenerics) {
                buffer.append(JavaUtil.getQualifiedName(parameterizedType.getType(), removeGenerics));
            } else {
                buffer.append(parameterizedType.getName());
            }
        } else if (object instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)object;
            if (typeDeclaration.eContainer() instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration superTypeDeclaration = (AbstractTypeDeclaration)typeDeclaration.eContainer();
                buffer.append(JavaUtil.getQualifiedName(superTypeDeclaration, removeGenerics));
                buffer.append('.');
            } else if (typeDeclaration.eContainer() instanceof Package) {
                Package packaje = (Package)typeDeclaration.eContainer();
                buffer.append(JavaUtil.getQualifiedName(packaje, removeGenerics));
                buffer.append('.');
            } else if (!(typeDeclaration.eContainer() instanceof Model)) {
                if (typeDeclaration.eContainer() != null) {
                    MoDiscoLogger.logWarning((String)"Not managed type declaration: typeDeclaration.eContainer().getClass()= ", (Plugin)JavaPlugin.getDefault());
                } else {
                    MoDiscoLogger.logWarning((String)"Type with null container", (Plugin)JavaPlugin.getDefault());
                }
            }
            buffer.append(typeDeclaration.getName());
        } else if (object instanceof Package) {
            Package packaje = (Package)object;
            if (packaje.eContainer() instanceof Package) {
                Package superPackage = (Package)packaje.eContainer();
                buffer.append(JavaUtil.getQualifiedName(superPackage, removeGenerics));
                buffer.append('.');
            }
            buffer.append(packaje.getName());
        } else if (object instanceof TypeAccess) {
            TypeAccess typeAccess = (TypeAccess)object;
            buffer.append(JavaUtil.getQualifiedName(typeAccess.getType(), removeGenerics));
        } else if (object instanceof Model) {
            Exception e = new Exception("getQualified name should note be called with a model as parameter");
            Status status = new Status(4, "org.eclipse.modisco.java", e.getMessage(), (Throwable)e);
            JavaPlugin.getDefault().getLog().log((IStatus)status);
        } else if (object instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)object;
            buffer.append(primitiveType.getName());
        } else if (!(object instanceof AnonymousClassDeclaration)) {
            if (object instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)object;
                if (!(singleVariableDeclaration.eContainer() instanceof CatchClause)) {
                    buffer.append(JavaUtil.getQualifiedName((ASTNode)singleVariableDeclaration.eContainer(), removeGenerics));
                    buffer.append('.');
                }
                buffer.append(singleVariableDeclaration.getName());
            } else if (object != null) {
                Exception e = new Exception("Not managed type: " + object.getClass().getName());
                Status status = new Status(4, "org.eclipse.modisco.java", e.getMessage(), (Throwable)e);
                JavaPlugin.getDefault().getLog().log((IStatus)status);
            } else {
                buffer.append("<<null>>");
            }
        }
        if (Platform.inDebugMode() && TRACE_GETQNAME) {
            System.out.println("JavaUtil.getQualifiedName(EObject)= " + buffer.toString());
        }
        return buffer.toString();
    }

    public static NamedElement getNamedElementByQualifiedName(Model model, String searchedQualifiedName) {
        return JavaUtil.getNamedElementByQualifiedName(model, searchedQualifiedName, new HashMap<String, NamedElement>());
    }

    /*
     * Unable to fully structure code
     */
    public static NamedElement getNamedElementByQualifiedName(Model model, String searchedQualifiedName, Map<String, NamedElement> targets) {
        block29: {
            block28: {
                if (JavaUtil.TRACE_NE_BY_QN) {
                    System.out.println("Begin getNamedElementByQualifiedName(Model, String): " + searchedQualifiedName);
                }
                resultNamedElement /* !! */  = null;
                javaUtil = new JavaUtil();
                currentElement = javaUtil.new CurrentElement();
                if (searchedQualifiedName != null) break block28;
                MoDiscoLogger.logError((String)"JavaDiscovererUtils::getNamedElementByQualifiedName(): qualifiedName parameter is null", (Plugin)JavaPlugin.getDefault());
                break block29;
            }
            for (Type orphanType : model.getOrphanTypes()) {
                if (!searchedQualifiedName.equals(orphanType.getName())) continue;
                resultNamedElement /* !! */  = orphanType;
            }
            end = false;
            ** GOTO lbl119
            {
                block27: {
                    try {
                        if (currentElement.isEmpty()) {
                            packages = model.getOwnedElements().iterator();
                            while (packages.hasNext() && resultNamedElement /* !! */  == null) {
                                packaje = (Package)packages.next();
                                currentPackageName = JavaUtil.getQualifiedName(packaje, false);
                                if (!searchedQualifiedName.startsWith(currentPackageName)) continue;
                                if (searchedQualifiedName.equals(currentPackageName)) {
                                    resultNamedElement /* !! */  = packaje;
                                    continue;
                                }
                                currentElement.setElement(packaje);
                            }
                            break block27;
                        }
                        if (currentElement.getElement() instanceof Package) {
                            packaje = (Package)currentElement.getElement();
                            packages = packaje.getOwnedPackages().iterator();
                            while (packages.hasNext() && resultNamedElement /* !! */  == null) {
                                subpackage = (Package)packages.next();
                                subPackageName = JavaUtil.getQualifiedName(subpackage, false);
                                if (!searchedQualifiedName.startsWith(subPackageName)) continue;
                                if (searchedQualifiedName.equals(subPackageName)) {
                                    resultNamedElement /* !! */  = subpackage;
                                    continue;
                                }
                                currentElement.setElement(subpackage);
                            }
                            abstractTypeDeclarations = packaje.getOwnedElements().iterator();
                            while (abstractTypeDeclarations.hasNext() && resultNamedElement /* !! */  == null) {
                                atd = (AbstractTypeDeclaration)abstractTypeDeclarations.next();
                                atdName = JavaUtil.getQualifiedName(atd, false);
                                if (!searchedQualifiedName.startsWith(atdName)) continue;
                                if (searchedQualifiedName.equals(atdName)) {
                                    resultNamedElement /* !! */  = atd;
                                    continue;
                                }
                                currentElement.setElement(atd);
                            }
                            break block27;
                        }
                        if (currentElement.getElement() instanceof AbstractTypeDeclaration) {
                            abstractTypeDeclaration = (AbstractTypeDeclaration)currentElement.getElement();
                            bodyDeclarations = abstractTypeDeclaration.getBodyDeclarations();
                            if (abstractTypeDeclaration instanceof EnumDeclaration) {
                                bodyDeclarations.addAll((Collection<BodyDeclaration>)((EnumDeclaration)abstractTypeDeclaration).getEnumConstants());
                            }
                            it = bodyDeclarations.iterator();
                            while (it.hasNext() && resultNamedElement /* !! */  == null) {
                                bodyDeclaration = (BodyDeclaration)it.next();
                                if (bodyDeclaration instanceof AbstractTypeDeclaration) {
                                    subAbstractTypeDeclaration = (AbstractTypeDeclaration)bodyDeclaration;
                                    subATDQN = JavaUtil.getQualifiedName(subAbstractTypeDeclaration, false);
                                    if (!searchedQualifiedName.startsWith(subATDQN)) continue;
                                    if (searchedQualifiedName.equals(subATDQN)) {
                                        resultNamedElement /* !! */  = subAbstractTypeDeclaration;
                                        continue;
                                    }
                                    currentElement.setElement(subAbstractTypeDeclaration);
                                    continue;
                                }
                                if (targets.containsValue(bodyDeclaration)) continue;
                                if (bodyDeclaration instanceof AbstractMethodDeclaration) {
                                    abstractMethodDeclaration = (AbstractMethodDeclaration)bodyDeclaration;
                                    amdQN = JavaUtil.getQualifiedName(abstractMethodDeclaration, true);
                                    if (amdQN.contains("<<null>>")) {
                                        status = new Status(2, "org.eclipse.modisco.java", "Failed to compute qualifiedName:" + amdQN + " ; searchedQualifiedName= " + searchedQualifiedName, (Throwable)new Exception());
                                        JavaPlugin.getDefault().getLog().log((IStatus)status);
                                    }
                                    if (!searchedQualifiedName.startsWith(amdQN)) continue;
                                    if (searchedQualifiedName.equals(amdQN)) {
                                        resultNamedElement /* !! */  = abstractMethodDeclaration;
                                        continue;
                                    }
                                    currentElement.setElement(abstractMethodDeclaration);
                                    continue;
                                }
                                if (bodyDeclaration instanceof FieldDeclaration) {
                                    fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                                    for (VariableDeclarationFragment variableDeclarationFragment : fieldDeclaration.getFragments()) {
                                        variableDeclarationFragmentQN = JavaUtil.getQualifiedName(variableDeclarationFragment, false);
                                        if (!searchedQualifiedName.equals(variableDeclarationFragmentQN)) continue;
                                        resultNamedElement /* !! */  = variableDeclarationFragment;
                                    }
                                    continue;
                                }
                                if (bodyDeclaration instanceof EnumConstantDeclaration) {
                                    enumConstantDeclaration = (EnumConstantDeclaration)bodyDeclaration;
                                    enumConstantQN = JavaUtil.getQualifiedName(enumConstantDeclaration, false);
                                    if (!searchedQualifiedName.equals(enumConstantQN)) continue;
                                    resultNamedElement /* !! */  = enumConstantDeclaration;
                                    continue;
                                }
                                if (bodyDeclaration instanceof AnnotationTypeMemberDeclaration) {
                                    annoMemberDeclaration = (AnnotationTypeMemberDeclaration)bodyDeclaration;
                                    enumConstantQN = JavaUtil.getQualifiedName(annoMemberDeclaration, false);
                                    if (!searchedQualifiedName.equals(enumConstantQN)) continue;
                                    resultNamedElement /* !! */  = annoMemberDeclaration;
                                    continue;
                                }
                                if (bodyDeclaration instanceof Initializer) continue;
                                throw new RuntimeException("Unexpected type in an AbstractTypeDeclaration contaiment: " + bodyDeclaration.getClass().getName());
                            }
                            break block27;
                        }
                        end = true;
                    }
                    catch (Exception e) {
                        runtimeException = new RuntimeException("getNamedElementByQualifiedName failed while reading:" + JavaUtil.getQualifiedName((ASTNode)currentElement.getElement(), false), e);
                        status = new Status(4, "org.eclipse.modisco.java", runtimeException.getMessage(), (Throwable)runtimeException);
                        JavaPlugin.getDefault().getLog().log((IStatus)status);
                        throw runtimeException;
                    }
                }
                do {
                    if (resultNamedElement /* !! */  == null && !end && currentElement.hasChanged2()) continue block3;
lbl119:
                    // 2 sources

                } while (currentElement.nextIndex() && resultNamedElement /* !! */  == null);
            }
            if (JavaUtil.TRACE_NE_BY_QN) {
                System.out.println("End getNamedElementByQualifiedName(Model, String): result=" + resultNamedElement /* !! */ );
            }
        }
        return resultNamedElement /* !! */ ;
    }

    private class CurrentElement {
        private EObject currentElement = null;
        private final List<EObject> element = new ArrayList<EObject>();
        private boolean hasChanged = false;
        private boolean hasChanged2 = true;
        private boolean init = true;

        public void setElement(EObject element) {
            this.element.add(element);
            if (this.currentElement == null) {
                this.currentElement = element;
            }
            this.hasChanged = false;
            this.hasChanged2 = true;
        }

        public boolean hasChanged() {
            if (this.hasChanged) {
                this.hasChanged = false;
                return true;
            }
            return false;
        }

        public boolean hasChanged2() {
            if (this.hasChanged2) {
                this.hasChanged2 = false;
                if (this.element.size() > 0) {
                    this.currentElement = this.element.get(0);
                    this.element.remove(0);
                }
                return true;
            }
            return false;
        }

        public EObject getElement() {
            return this.currentElement;
        }

        public boolean isEmpty() {
            return this.currentElement == null;
        }

        public boolean nextIndex() {
            if (this.init) {
                this.init = false;
                return true;
            }
            this.hasChanged = false;
            this.hasChanged2 = true;
            return this.element.size() > 0;
        }
    }
}

