/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.forms.parts;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.forms.activator.UIPlugin;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatable;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractSection
extends SectionPart
implements IAdaptable,
IValidatable {
    private String message = null;
    private int messageType = 0;
    private boolean updating = true;
    boolean readOnly = false;
    boolean enabled = true;

    public AbstractSection(IManagedForm form, Composite parent, int style) {
        this(form, parent, style, true);
    }

    public AbstractSection(IManagedForm form, Composite parent, int style, boolean titleBar) {
        super(parent, form.getToolkit(), titleBar ? 0x100 | style : style);
        this.initialize(form);
        this.configureSection(this.getSection());
    }

    protected IValidatingContainer getValidatingContainer() {
        Object container = this.getManagedForm().getContainer();
        return container instanceof IValidatingContainer ? (IValidatingContainer)container : null;
    }

    protected void configureSection(Section section) {
        Assert.isNotNull((Object)section);
        section.clientVerticalSpacing = 6;
        section.setData("part", (Object)this);
        Color bg = section.getParent().getBackground();
        if (bg != null && !bg.equals((Object)section.getBackground())) {
            section.setBackground(bg);
        }
    }

    protected abstract void createClient(Section var1, FormToolkit var2);

    protected Composite createClientContainer(Composite parent, int numColumns, FormToolkit toolkit) {
        return this.createClientContainer(parent, numColumns, false, toolkit);
    }

    protected Composite createClientContainer(Composite parent, int numColumns, boolean makeColumnsEqualWith, FormToolkit toolkit) {
        Composite container = toolkit != null ? toolkit.createComposite(parent) : new Composite(parent, 0);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(makeColumnsEqualWith, numColumns));
        Color bg = parent.getBackground();
        if (bg != null && !bg.equals((Object)container.getBackground())) {
            container.setBackground(bg);
        }
        return container;
    }

    protected Label createEmptySpace(Composite parent, int span, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Label emptySpace = toolkit != null ? toolkit.createLabel(parent, null) : new Label(parent, 0);
        GridData layoutData = new GridData(1, 1, false, false);
        layoutData.horizontalSpan = span;
        layoutData.widthHint = 0;
        layoutData.heightHint = SWTControlUtil.convertHeightInCharsToPixels((Control)emptySpace, (int)1) / 2;
        emptySpace.setLayoutData((Object)layoutData);
        return emptySpace;
    }

    protected void createSectionToolbar(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        ToolBarManager tlbMgr = new ToolBarManager(0x800000);
        ToolBar tlb = tlbMgr.createControl((Composite)section);
        final Cursor cursor = new Cursor((Device)Display.getCurrent(), 21);
        tlb.setCursor(cursor);
        tlb.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!cursor.isDisposed()) {
                    cursor.dispose();
                }
            }
        });
        this.createSectionToolbarItems(section, toolkit, tlbMgr);
        tlbMgr.update(true);
        section.setTextClient((Control)tlb);
    }

    protected void createSectionToolbarItems(Section section, FormToolkit toolkit, ToolBarManager tlbMgr) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)tlbMgr);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public final void markDirty(boolean dirty) {
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/sections/dirtyState")) {
            UIPlugin.getTraceHandler().trace("markDirty: Set dirty state to " + dirty, "trace/sections/dirtyState", (Object)this);
        }
        if (dirty) {
            this.markDirty();
            if (this.getManagedForm() != null) {
                this.getManagedForm().dirtyStateChanged();
            }
        } else {
            try {
                final Field f = AbstractFormPart.class.getDeclaredField("dirty");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        f.setAccessible(true);
                        return null;
                    }
                });
                f.setBoolean((Object)this, dirty);
                if (this.getManagedForm() != null) {
                    this.getManagedForm().dirtyStateChanged();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void markStale(boolean stale) {
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/sections/staleState")) {
            UIPlugin.getTraceHandler().trace("markStale: Set stale state to " + stale, "trace/sections/staleState", (Object)this);
        }
        if (stale) {
            this.markStale();
        } else {
            try {
                final Field f = AbstractFormPart.class.getDeclaredField("stale");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        f.setAccessible(true);
                        return null;
                    }
                });
                f.setBoolean((Object)this, stale);
                if (this.getManagedForm() != null) {
                    this.getManagedForm().staleStateChanged();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void commit(boolean onSave) {
        if (onSave) {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/sections/dirtyState")) {
                UIPlugin.getTraceHandler().trace("Commit(" + onSave + ") reseted the dirty state to false.", "trace/sections/dirtyState", (Object)this);
            }
            super.commit(onSave);
            this.getManagedForm().dirtyStateChanged();
        }
    }

    public void refresh() {
        boolean hasBeenStale = this.isStale();
        boolean hasBeenDirty = this.isDirty();
        super.refresh();
        if (hasBeenStale) {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/sections/staleState")) {
                UIPlugin.getTraceHandler().trace("refresh() reseted the stale state to false.", "trace/sections/staleState", (Object)this);
            }
            this.getManagedForm().staleStateChanged();
        }
        if (hasBeenDirty) {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/sections/dirtyState")) {
                UIPlugin.getTraceHandler().trace("refresh() reseted the dirty state to false.", "trace/sections/dirtyState", (Object)this);
            }
            this.getManagedForm().dirtyStateChanged();
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isValid() {
        this.setMessage(null, 0);
        return true;
    }

    protected final void setMessage(String message, int messageType) {
        this.message = message;
        this.messageType = messageType;
    }

    public final String getMessage() {
        return this.message;
    }

    public final int getMessageType() {
        return this.messageType;
    }

    protected final void setIsUpdating(boolean updating) {
        this.updating = updating;
    }

    protected final boolean isUpdating() {
        return this.updating;
    }

    public void saveWidgetValues(IDialogSettings settings) {
    }

    public void restoreWidgetValues(IDialogSettings settings) {
    }
}

