/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.ui.Messages;
import org.eclipse.unittest.model.ITestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CompareResultDialog
extends TrayDialog {
    private static final String PREFIX_SUFFIX_PROPERTY = "org.eclipse.unittest.ui.CompareResultDialog.prefixSuffix";
    private TextMergeViewer fViewer;
    private ITestElement.FailureTrace trace;
    private String fTestName;
    private final int[] fPrefixSuffix = new int[2];
    private CompareViewerPane fCompareViewerPane;

    public CompareResultDialog(Shell parentShell, TestElement element) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF | 4);
        this.setFailedTest(element);
    }

    protected boolean isResizable() {
        return true;
    }

    private void setFailedTest(TestElement failedTest) {
        this.fTestName = failedTest.getTestName();
        this.trace = failedTest.getFailureTrace();
        this.computePrefixSuffix();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettingsSection(((Object)((Object)this)).getClass().getName());
    }

    private IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass())).getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    private void computePrefixSuffix() {
        String expected = this.trace.getExpected();
        String actual = this.trace.getActual();
        int end = Math.min(expected.length(), actual.length());
        int i = 0;
        while (i < end) {
            if (expected.charAt(i) != actual.charAt(i)) break;
            ++i;
        }
        this.fPrefixSuffix[0] = i;
        int j = expected.length() - 1;
        int k = actual.length() - 1;
        int l = 0;
        while (k >= i && j >= i) {
            if (expected.charAt(j) != actual.charAt(k)) break;
            ++l;
            --k;
            --j;
        }
        this.fPrefixSuffix[1] = l;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CompareResultDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.unittest.ui.result_compare_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.fCompareViewerPane = new CompareViewerPane(composite, 0x800800);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        data.heightHint = this.convertHeightInCharsToPixels(13);
        this.fCompareViewerPane.setLayoutData((Object)data);
        Control previewer = this.createPreviewer((Composite)this.fCompareViewerPane);
        this.fCompareViewerPane.setContent(previewer);
        GridData gd = new GridData(1808);
        previewer.setLayoutData((Object)gd);
        CompareResultDialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Control createPreviewer(Composite parent) {
        CompareConfiguration compareConfiguration = new CompareConfiguration();
        compareConfiguration.setLeftLabel(Messages.CompareResultDialog_expectedLabel);
        compareConfiguration.setLeftEditable(false);
        compareConfiguration.setRightLabel(Messages.CompareResultDialog_actualLabel);
        compareConfiguration.setRightEditable(false);
        compareConfiguration.setProperty("IGNORE_WHITESPACE", (Object)Boolean.FALSE);
        compareConfiguration.setProperty(PREFIX_SUFFIX_PROPERTY, (Object)this.fPrefixSuffix);
        this.fViewer = new CompareResultMergeViewer(parent, 0, compareConfiguration);
        this.setCompareViewerInput();
        Control control = this.fViewer.getControl();
        control.addDisposeListener(e -> compareConfiguration.dispose());
        return control;
    }

    private void setCompareViewerInput() {
        if (!this.fViewer.getControl().isDisposed()) {
            this.fViewer.setInput((Object)new DiffNode((ITypedElement)new CompareElement(this.trace.getExpected()), (ITypedElement)new CompareElement(this.trace.getActual())));
            this.fCompareViewerPane.setText(this.fTestName);
        }
    }

    public void setInput(TestElement failedTest) {
        this.setFailedTest(failedTest);
        this.setCompareViewerInput();
    }

    private static class CompareElement
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private String fContent;

        public CompareElement(String content) {
            this.fContent = content;
        }

        public String getName() {
            return "<no name>";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.fContent.getBytes(StandardCharsets.UTF_8));
        }

        public String getCharset() throws CoreException {
            return "UTF-8";
        }
    }

    private static class CompareResultMergeViewer
    extends TextMergeViewer {
        private CompareResultMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
            super(parent, style, configuration);
        }

        protected void createControls(Composite composite) {
            super.createControls(composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.unittest.ui.result_compare_context");
        }

        protected void configureTextViewer(TextViewer textViewer) {
            if (textViewer instanceof SourceViewer) {
                int[] prefixSuffixOffsets = (int[])this.getCompareConfiguration().getProperty(CompareResultDialog.PREFIX_SUFFIX_PROPERTY);
                ((SourceViewer)textViewer).configure((SourceViewerConfiguration)new CompareResultViewerConfiguration(prefixSuffixOffsets));
            }
        }
    }

    private static class CompareResultViewerConfiguration
    extends SourceViewerConfiguration {
        private final int[] fPrefixSuffixOffsets;

        public CompareResultViewerConfiguration(int[] prefixSuffixOffsets) {
            this.fPrefixSuffixOffsets = prefixSuffixOffsets;
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            PresentationReconciler reconciler = new PresentationReconciler();
            SimpleDamagerRepairer dr = new SimpleDamagerRepairer(this.fPrefixSuffixOffsets);
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            return reconciler;
        }

        private static class SimpleDamagerRepairer
        implements IPresentationDamager,
        IPresentationRepairer {
            private IDocument fDocument;
            private final int[] fPrefixSuffixOffsets2;

            public SimpleDamagerRepairer(int[] prefixSuffixOffsets) {
                this.fPrefixSuffixOffsets2 = prefixSuffixOffsets;
            }

            public void setDocument(IDocument document) {
                this.fDocument = document;
            }

            public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean changed) {
                return new Region(0, this.fDocument.getLength());
            }

            public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
                presentation.setDefaultStyleRange(new StyleRange(0, this.fDocument.getLength(), null, null));
                int prefix = this.fPrefixSuffixOffsets2[0];
                int suffix = this.fPrefixSuffixOffsets2[1];
                TextAttribute attr = new TextAttribute(Display.getDefault().getSystemColor(3));
                presentation.addStyleRange(new StyleRange(prefix, this.fDocument.getLength() - suffix - prefix, attr.getForeground(), attr.getBackground(), attr.getStyle()));
            }
        }
    }
}

