/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLSource;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPath;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPathHolder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParser
extends DefaultHandler
implements Runnable {
    private static Logger logger = Logger.getLogger(SaxParser.class.getName());
    private static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";
    private InputStream inputStream;
    private String encoding;
    private ISaxParserConsumer spConsumer;
    private Map<String, StringBuilder> cachedValues;
    private boolean stopFlag;
    private boolean useNamespace;
    private Map prefixMap;
    private List exceptions;
    private XMLPathHolder pathHolder;
    private XMLPath currentElementPath;

    public SaxParser(IXMLSource xmlSource, ISaxParserConsumer consumer, boolean useNamespace) throws OdaException {
        this.inputStream = xmlSource.openInputStream();
        this.encoding = "".equals(xmlSource.getEncoding()) ? null : xmlSource.getEncoding();
        this.spConsumer = consumer;
        this.useNamespace = useNamespace;
        this.stopFlag = false;
        this.cachedValues = new HashMap<String, StringBuilder>();
        this.exceptions = new ArrayList();
        this.prefixMap = new HashMap();
    }

    @Override
    public void run() {
        block12: {
            try {
                try {
                    Object xmlReader = this.createXMLReader();
                    this.setContentHandler(xmlReader);
                    this.setErrorHandler(xmlReader);
                    this.parse(xmlReader);
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof ThreadStopException)) {
                        logger.log(Level.WARNING, "Exceptions occur during xml parsing", e);
                        this.exceptions.add(e);
                    }
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException iOException) {}
                    this.spConsumer.finish();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {}
                this.spConsumer.finish();
                throw throwable;
            }
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
            this.spConsumer.finish();
        }
    }

    public boolean exceptionOccurred() {
        return !this.exceptions.isEmpty();
    }

    private void parse(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method parse = this.getMethod("parse", xmlReader.getClass(), new Class[]{InputSource.class});
        InputSource source = new InputSource(this.inputStream);
        source.setEncoding(this.encoding);
        parse.invoke(xmlReader, source);
    }

    private void setErrorHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setErrorHandler = this.getMethod("setErrorHandler", xmlReader.getClass(), new Class[]{ErrorHandler.class});
        this.invokeMethod(setErrorHandler, xmlReader, new Object[]{this});
    }

    private void setContentHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setContentHandler = this.getMethod("setContentHandler", xmlReader.getClass(), new Class[]{ContentHandler.class});
        this.invokeMethod(setContentHandler, xmlReader, new Object[]{this});
    }

    private Object createXMLReader() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            Object xmlReader = Thread.currentThread().getContextClassLoader().loadClass(SAX_PARSER).newInstance();
            return xmlReader;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(SAX_PARSER).newInstance();
        }
    }

    private Method getMethod(String methodName, Class targetClass, Class[] argument) throws SecurityException, NoSuchMethodException {
        assert (methodName != null);
        assert (targetClass != null);
        assert (argument != null);
        return targetClass.getMethod(methodName, argument);
    }

    private void invokeMethod(Method method, Object targetObject, Object[] argument) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        method.invoke(targetObject, argument);
    }

    @Override
    public void startDocument() {
        this.pathHolder = new XMLPathHolder();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.stopFlag) {
            throw new ThreadStopException();
        }
        String elementName = qName;
        if (this.useNamespace && !qName.equals(name)) {
            elementName = String.valueOf(uri.replaceAll("/", "%")) + ":" + name;
        }
        this.pathHolder.startElement(elementName);
        this.currentElementPath = this.pathHolder.getCurrentElementPath();
        this.spConsumer.startElement(this.currentElementPath);
        int i = 0;
        while (i < atts.getLength()) {
            this.spConsumer.manipulateData(this.pathHolder.getCurrentAttrPath(atts.getQName(i)), atts.getValue(i));
            ++i;
        }
        if (this.spConsumer instanceof SaxParserConsumer) {
            i = 0;
            while (i < atts.getLength()) {
                this.spConsumer.manipulateData(this.pathHolder.getCurrentAttrPath(atts.getQName(i)), atts.getValue(i));
                ++i;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String pathString = this.currentElementPath.getPathString();
        StringBuilder cachedValue = this.cachedValues.get(pathString);
        if (cachedValue == null) {
            value = "";
        } else {
            value = cachedValue.toString();
            this.cachedValues.remove(this.currentElementPath.getPathString());
        }
        this.spConsumer.manipulateData(this.currentElementPath, value);
        this.spConsumer.endElement(this.currentElementPath);
        this.pathHolder.endElement();
        this.currentElementPath = this.pathHolder.getCurrentElementPath();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String pathString = this.currentElementPath.getPathString();
        StringBuilder cachedValue = this.cachedValues.get(pathString);
        if (cachedValue == null) {
            cachedValue = new StringBuilder(length > 0 ? length : 64);
            this.cachedValues.put(pathString, cachedValue);
        }
        cachedValue.append(ch, start, length);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMap.put(prefix, uri.replaceAll("/", "%"));
    }

    public Map getPrefixMapping() {
        return this.prefixMap;
    }

    public void stopParsing() {
        this.stopFlag = true;
    }

    private static class ThreadStopException
    extends RuntimeException {
        private static final long serialVersionUID = 7871277314833138093L;

        ThreadStopException() {
        }
    }
}

