/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.workingsets.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.util.BaseSwitch;
import org.eclipse.oomph.predicates.AndPredicate;
import org.eclipse.oomph.predicates.NotPredicate;
import org.eclipse.oomph.predicates.OrPredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.util.PredicatesSwitch;
import org.eclipse.oomph.workingsets.WorkingSetsFactory;
import org.eclipse.oomph.workingsets.provider.ExclusionPredicateItemProvider;
import org.eclipse.oomph.workingsets.provider.InclusionPredicateItemProvider;
import org.eclipse.oomph.workingsets.provider.WorkingSetGroupItemProvider;
import org.eclipse.oomph.workingsets.provider.WorkingSetItemProvider;
import org.eclipse.oomph.workingsets.provider.WorkingSetsEditPlugin;
import org.eclipse.oomph.workingsets.util.WorkingSetsAdapterFactory;

public class WorkingSetsItemProviderAdapterFactory
extends WorkingSetsAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected WorkingSetItemProvider workingSetItemProvider;
    protected WorkingSetGroupItemProvider workingSetGroupItemProvider;
    protected ExclusionPredicateItemProvider exclusionPredicateItemProvider;
    protected InclusionPredicateItemProvider inclusionPredicateItemProvider;

    public WorkingSetsItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createWorkingSetAdapter() {
        if (this.workingSetItemProvider == null) {
            this.workingSetItemProvider = new WorkingSetItemProvider((AdapterFactory)this);
        }
        return this.workingSetItemProvider;
    }

    public Adapter createWorkingSetGroupAdapter() {
        if (this.workingSetGroupItemProvider == null) {
            this.workingSetGroupItemProvider = new WorkingSetGroupItemProvider((AdapterFactory)this);
        }
        return this.workingSetGroupItemProvider;
    }

    public Adapter createExclusionPredicateAdapter() {
        if (this.exclusionPredicateItemProvider == null) {
            this.exclusionPredicateItemProvider = new ExclusionPredicateItemProvider((AdapterFactory)this);
        }
        return this.exclusionPredicateItemProvider;
    }

    public Adapter createInclusionPredicateAdapter() {
        if (this.inclusionPredicateItemProvider == null) {
            this.inclusionPredicateItemProvider = new InclusionPredicateItemProvider((AdapterFactory)this);
        }
        return this.inclusionPredicateItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.workingSetItemProvider != null) {
            this.workingSetItemProvider.dispose();
        }
        if (this.workingSetGroupItemProvider != null) {
            this.workingSetGroupItemProvider.dispose();
        }
        if (this.inclusionPredicateItemProvider != null) {
            this.inclusionPredicateItemProvider.dispose();
        }
        if (this.exclusionPredicateItemProvider != null) {
            this.exclusionPredicateItemProvider.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BaseChildCreationExtender
    implements IChildCreationExtender {
        public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
            ArrayList<Object> result = new ArrayList<Object>();
            new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
            return result;
        }

        public ResourceLocator getResourceLocator() {
            return WorkingSetsEditPlugin.INSTANCE;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class CreationSwitch
        extends BaseSwitch<Object> {
            protected List<Object> newChildDescriptors;
            protected EditingDomain editingDomain;

            CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            public Object caseAnnotation(Annotation object) {
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, WorkingSetsFactory.eINSTANCE.createWorkingSet()));
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, WorkingSetsFactory.eINSTANCE.createWorkingSetGroup()));
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, WorkingSetsFactory.eINSTANCE.createInclusionPredicate()));
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, WorkingSetsFactory.eINSTANCE.createExclusionPredicate()));
                return null;
            }

            protected CommandParameter createChildParameter(Object feature, Object child) {
                return new CommandParameter(null, feature, child);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PredicatesChildCreationExtender
    implements IChildCreationExtender {
        public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
            ArrayList<Object> result = new ArrayList<Object>();
            new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
            return result;
        }

        public ResourceLocator getResourceLocator() {
            return WorkingSetsEditPlugin.INSTANCE;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class CreationSwitch
        extends PredicatesSwitch<Object> {
            protected List<Object> newChildDescriptors;
            protected EditingDomain editingDomain;

            CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            public Object caseAndPredicate(AndPredicate object) {
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.AND_PREDICATE__OPERANDS, WorkingSetsFactory.eINSTANCE.createInclusionPredicate()));
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.AND_PREDICATE__OPERANDS, WorkingSetsFactory.eINSTANCE.createExclusionPredicate()));
                return null;
            }

            public Object caseOrPredicate(OrPredicate object) {
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.OR_PREDICATE__OPERANDS, WorkingSetsFactory.eINSTANCE.createInclusionPredicate()));
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.OR_PREDICATE__OPERANDS, WorkingSetsFactory.eINSTANCE.createExclusionPredicate()));
                return null;
            }

            public Object caseNotPredicate(NotPredicate object) {
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.NOT_PREDICATE__OPERAND, WorkingSetsFactory.eINSTANCE.createInclusionPredicate()));
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.NOT_PREDICATE__OPERAND, WorkingSetsFactory.eINSTANCE.createExclusionPredicate()));
                return null;
            }

            protected CommandParameter createChildParameter(Object feature, Object child) {
                return new CommandParameter(null, feature, child);
            }
        }
    }
}

