/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.reddeer.junit.requirement.RequirementException;

public class ReflectionUtil {
    public static Object getValue(Object obj, String propertySyntax) {
        if (obj == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (propertySyntax == null || propertySyntax.length() == 0) {
            throw new IllegalArgumentException("Property syntax cannot be null or empty");
        }
        Object result = obj;
        String[] properties = propertySyntax.split("\\.");
        ArrayList<String> propertyPath = new ArrayList<String>();
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (result == null) {
                throw new RequirementException("Cannot access " + propertySyntax + " since " + String.join((CharSequence)".", propertyPath) + " was resolved as null");
            }
            String methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            try {
                Method method = result.getClass().getMethod(methodName, new Class[0]);
                result = method.invoke(result, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new RequirementException("Cannot access " + property + " in " + result.getClass().getCanonicalName(), e);
            }
            propertyPath.add(property);
            ++n2;
        }
        return result;
    }
}

