/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.widget;

import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.ui.internal.i18n.UiMessages;
import org.eclipse.buildship.ui.internal.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.internal.util.widget.HoverText;
import org.eclipse.buildship.ui.internal.util.widget.StringListEditor;
import org.eclipse.buildship.ui.internal.util.widget.UiBuilder;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class AdvancedOptionsGroup
extends Group {
    private final UiBuilder.UiBuilderFactory builderFactory;
    private Text gradleUserHomeText;
    private Button gradleUserHomeBrowseButton;
    private Label gradleUserHomeWarningLabel;
    private Text javaHomeText;
    private Button javaHomeBrowseButton;
    private Label javaHomeWarningLabel;
    private StringListEditor argumentsEditor;
    private StringListEditor jvmArgumentsEditor;

    public AdvancedOptionsGroup(Composite parent, boolean variableSelector) {
        super(parent, 0);
        this.setText(CoreMessages.Preference_Label_AdvancedOptions);
        this.builderFactory = new UiBuilder.UiBuilderFactory(JFaceResources.getDialogFont());
        this.setLayoutData(new GridData(4, 128, true, false));
        this.setLayout((Layout)new GridLayout(4, false));
        this.builderFactory.newLabel((Composite)this).alignLeft().text(CoreMessages.Preference_Label_Gradle_User_Home);
        this.gradleUserHomeText = this.builderFactory.newText((Composite)this).alignFillHorizontal().control();
        this.gradleUserHomeBrowseButton = this.builderFactory.newButton((Composite)this).alignLeft().text(UiMessages.Button_Label_Browse).control();
        this.gradleUserHomeWarningLabel = this.builderFactory.newLabel((Composite)this).alignLeft().control();
        this.gradleUserHomeWarningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        HoverText.createAndAttach((Control)this.gradleUserHomeWarningLabel, NLS.bind((String)CoreMessages.WarningMessage_Using_0_NonPortable, (Object)"Gradle user home"));
        this.builderFactory.newLabel((Composite)this).alignLeft().text(CoreMessages.Preference_Label_Java_Home);
        this.javaHomeText = this.builderFactory.newText((Composite)this).alignFillHorizontal().control();
        this.javaHomeBrowseButton = this.builderFactory.newButton((Composite)this).alignLeft().text(UiMessages.Button_Label_Browse).control();
        this.javaHomeWarningLabel = this.builderFactory.newLabel((Composite)this).alignLeft().control();
        this.javaHomeWarningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        HoverText.createAndAttach((Control)this.gradleUserHomeWarningLabel, NLS.bind((String)CoreMessages.WarningMessage_Using_0_NonPortable, (Object)"Java home"));
        this.builderFactory.newLabel((Composite)this).alignLeft().text(CoreMessages.RunConfiguration_Label_Arguments);
        this.argumentsEditor = new StringListEditor((Composite)this, variableSelector, "arg");
        this.builderFactory.newLabel((Composite)this).alignLeft().text(CoreMessages.RunConfiguration_Label_JvmArguments);
        this.jvmArgumentsEditor = new StringListEditor((Composite)this, variableSelector, "jvmArg");
        this.addListeners();
    }

    private void addListeners() {
        this.gradleUserHomeText.addModifyListener(l -> this.updateWarningVisibility());
        this.javaHomeText.addModifyListener(l -> this.updateWarningVisibility());
        this.gradleUserHomeBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(this.getShell(), this.gradleUserHomeText, "Gradle user home"));
        this.javaHomeBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(this.getShell(), this.javaHomeText, "Java home"));
    }

    public Text getGradleUserHomeText() {
        return this.gradleUserHomeText;
    }

    public Text getJavaHomeText() {
        return this.javaHomeText;
    }

    public StringListEditor getArgumentsEditor() {
        return this.argumentsEditor;
    }

    public StringListEditor getJvmArgumentsEditor() {
        return this.jvmArgumentsEditor;
    }

    protected void checkSubclass() {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean groupEnabled = this.getEnabled();
        this.gradleUserHomeText.setEnabled(groupEnabled);
        this.gradleUserHomeBrowseButton.setEnabled(groupEnabled);
        this.javaHomeText.setEnabled(groupEnabled);
        this.javaHomeBrowseButton.setEnabled(groupEnabled);
        this.argumentsEditor.setEnabled(groupEnabled);
        this.jvmArgumentsEditor.setEnabled(groupEnabled);
        this.updateWarningVisibility();
    }

    private void updateWarningVisibility() {
        boolean layout = false;
        layout |= AdvancedOptionsGroup.updateWarningVisibility(this.getEnabled(), this.gradleUserHomeText, this.gradleUserHomeWarningLabel);
        if (layout |= AdvancedOptionsGroup.updateWarningVisibility(this.getEnabled(), this.javaHomeText, this.javaHomeWarningLabel)) {
            this.getShell().layout(new Control[]{this}, 4);
        }
    }

    private static boolean updateWarningVisibility(boolean enabled, Text text, Label warning) {
        boolean warningShouldBeVisible;
        boolean warningIsVisible = warning.getVisible();
        boolean bl = warningShouldBeVisible = enabled && !text.getText().isEmpty();
        if (warningIsVisible != warningShouldBeVisible) {
            warning.setVisible(warningShouldBeVisible);
            Object layoutData = warning.getLayoutData();
            if (layoutData instanceof GridData) {
                GridData gridData = (GridData)layoutData;
                gridData.widthHint = warningShouldBeVisible ? -1 : 0;
                return true;
            }
        }
        return false;
    }

    public File getGradleUserHome() {
        String gradleUserHomeString = this.gradleUserHomeText.getText();
        return gradleUserHomeString.isEmpty() ? null : new File(gradleUserHomeString);
    }

    public void setGradleUserHome(File gradleUserHome) {
        if (gradleUserHome == null) {
            this.gradleUserHomeText.setText("");
        } else {
            this.gradleUserHomeText.setText(gradleUserHome.getPath());
        }
    }

    public File getJavaHome() {
        String javaHomeString = this.javaHomeText.getText();
        return javaHomeString.isEmpty() ? null : new File(javaHomeString);
    }

    public void setJavaHome(File javaHome) {
        if (javaHome == null) {
            this.javaHomeText.setText("");
        } else {
            this.javaHomeText.setText(javaHome.getPath());
        }
    }

    public List<String> getArguments() {
        return this.argumentsEditor.getEntries();
    }

    public void setArguments(List<String> arguments) {
        this.argumentsEditor.setEntries(arguments);
    }

    public List<String> getJvmArguments() {
        return this.jvmArgumentsEditor.getEntries();
    }

    public void setJvmArguments(List<String> jvmArguments) {
        this.jvmArgumentsEditor.setEntries(jvmArguments);
    }
}

