/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm;

import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumMapping;
import org.eclipse.jpt.jaxb.core.context.TypeKind;
import org.eclipse.jpt.jaxb.core.context.TypeName;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnum;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaJaxbEnum;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.AbstractOxmTypeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmTypeName;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlEnum;

public class OxmXmlEnumImpl
extends AbstractOxmTypeMapping
implements OxmXmlEnum {
    protected String specifiedJavaEnum;
    protected String value;
    protected String defaultValue;
    protected String specifiedValue;

    public OxmXmlEnumImpl(OxmXmlBindings parent, EXmlEnum eXmlEnum) {
        super(parent, eXmlEnum);
        this.initJavaEnum();
        this.initValue();
    }

    @Override
    public EXmlEnum getETypeMapping() {
        return (EXmlEnum)super.getETypeMapping();
    }

    public TypeKind getTypeKind() {
        return TypeKind.ENUM;
    }

    protected JavaEnum buildJavaType(JavaResourceAbstractType resourceType) {
        if (resourceType.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.ENUM) {
            return new GenericJavaJaxbEnum((JaxbContextNode)this, (JavaResourceEnum)resourceType);
        }
        return null;
    }

    @Override
    public JavaEnum getJavaType() {
        return (JavaEnum)super.getJavaType();
    }

    protected JaxbEnumMapping getJavaEnumMapping() {
        JavaEnum javaEnum = this.getJavaType();
        return javaEnum == null ? null : javaEnum.getMapping();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncJavaEnum();
        this.syncValue();
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public String getSpecifiedJavaEnum() {
        return this.specifiedJavaEnum;
    }

    protected void setSpecifiedJavaEnum_(String javaEnum) {
        String old = this.specifiedJavaEnum;
        this.specifiedJavaEnum = javaEnum;
        this.firePropertyChanged("specifiedJavaEnum", old, javaEnum);
    }

    @Override
    public void setSpecifiedJavaEnum(String javaEnum) {
        this.setSpecifiedJavaEnum_(javaEnum);
        this.getETypeMapping().setJavaEnum(javaEnum);
    }

    protected void initJavaEnum() {
        this.specifiedJavaEnum = this.getETypeMapping().getJavaEnum();
    }

    protected void syncJavaEnum() {
        this.setSpecifiedJavaEnum(this.getETypeMapping().getJavaEnum());
    }

    @Override
    protected void updateTypeName() {
        String newFqName;
        String fqName = this.typeName.getFullyQualifiedName();
        if (!ObjectTools.equals((Object)fqName, (Object)(newFqName = this.getXmlBindings().getQualifiedName(this.specifiedJavaEnum)))) {
            this.setTypeName_(this.buildTypeName());
        }
    }

    @Override
    protected TypeName buildTypeName() {
        return new OxmTypeName(this.getXmlBindings().getQualifiedName(this.specifiedJavaEnum));
    }

    public String getValue() {
        return this.value;
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, value);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue_(String value) {
        String old = this.defaultValue;
        this.defaultValue = value;
        this.firePropertyChanged("java.lang.String", old, value);
    }

    public String getSpecifiedValue() {
        return this.specifiedValue;
    }

    protected void setSpecifiedValue_(String value) {
        String old = this.specifiedValue;
        this.specifiedValue = value;
        this.firePropertyChanged("specifiedXmlEnum", old, value);
    }

    public void setSpecifiedValue(String value) {
        this.setSpecifiedValue_(value);
        this.getETypeMapping().setValue(value);
    }

    protected String buildDefaultValue() {
        String value;
        JaxbEnumMapping javaMapping;
        if (!this.getXmlBindings().isXmlMappingMetadataComplete() && (javaMapping = this.getJavaEnumMapping()) != null && (value = javaMapping.getSpecifiedValue()) != null) {
            return value;
        }
        return "java.lang.String";
    }

    protected void initValue() {
        this.defaultValue = this.buildDefaultValue();
        this.specifiedValue = this.getETypeMapping().getValue();
        this.value = this.specifiedValue == null ? this.defaultValue : this.specifiedValue;
    }

    protected void syncValue() {
        this.setDefaultValue_(this.buildDefaultValue());
        this.setSpecifiedValue_(this.getETypeMapping().getValue());
        String value = this.specifiedValue == null ? this.defaultValue : this.specifiedValue;
        this.setValue_(value);
    }

    public Iterable<JaxbEnumConstant> getEnumConstants() {
        return EmptyIterable.instance();
    }

    public int getEnumConstantsSize() {
        return 0;
    }

    public XsdSimpleTypeDefinition getValueXsdTypeDefinition() {
        return null;
    }
}

