/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.wizards.AbstractNewConfigWizard;
import org.eclipse.tcf.te.tcf.ui.wizards.pages.NewTargetWizardPage;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractWizardPage;
import org.eclipse.ui.IWorkbench;

public class NewWizard
extends AbstractNewConfigWizard {
    private static final AtomicInteger counter = new AtomicInteger();

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
    }

    public void addPages() {
        this.addPage((IWizardPage)new NewTargetWizardPage());
    }

    protected String getPeerType() {
        return null;
    }

    protected boolean isAllowedForeignAttribute(String key) {
        return key.equals("Name") || key.equals("TransportName") || key.equals("Host") || key.equals("Port") || key.equals("Proxies");
    }

    protected IPropertiesContainer getInitialData() {
        String autoConnectValue;
        IStructuredSelection selection = this.getSelection();
        PropertiesContainer data = new PropertiesContainer();
        if (selection != null) {
            IPeer peer;
            boolean isPeerNode = false;
            if (selection.getFirstElement() instanceof IPeer) {
                peer = (IPeer)selection.getFirstElement();
            } else if (selection.getFirstElement() instanceof ILocatorNode) {
                peer = ((ILocatorNode)selection.getFirstElement()).getPeer();
            } else if (selection.getFirstElement() instanceof IPeerNode) {
                isPeerNode = true;
                peer = ((IPeerNode)selection.getFirstElement()).getPeer();
            } else {
                peer = null;
            }
            if (peer != null) {
                String selPeerType = (String)peer.getAttributes().get("Type");
                final boolean sameType = this.getPeerType() == null ? selPeerType == null : this.getPeerType().equals(selPeerType);
                final boolean finIsPeerNode = isPeerNode;
                Protocol.invokeAndWait((Runnable)new Runnable((IPropertiesContainer)data){
                    private final /* synthetic */ IPropertiesContainer val$data;
                    {
                        this.val$data = iPropertiesContainer;
                    }

                    @Override
                    public void run() {
                        for (Map.Entry attribute : peer.getAttributes().entrySet()) {
                            if (!sameType && (finIsPeerNode || !NewWizard.this.isAllowedForeignAttribute((String)attribute.getKey())) || ((String)attribute.getKey()).endsWith("transient")) continue;
                            this.val$data.setProperty((String)attribute.getKey(), attribute.getValue());
                        }
                    }
                });
            }
        }
        boolean autoConnect = (autoConnectValue = UIPlugin.getScopedPreferences().getString("autoConnect." + this.getPeerType())) != null ? UIPlugin.getScopedPreferences().getBoolean("autoConnect." + this.getPeerType()) : true;
        data.setProperty("autoConnect", autoConnect);
        data.setProperty("Type", (Object)this.getPeerType());
        data.setProperty("URI.transient", null);
        data.setProperty("ID", (Object)UUID.randomUUID());
        return data;
    }

    protected void extractData(IPropertiesContainer peerAttributes) {
        Assert.isNotNull((Object)peerAttributes);
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof AbstractWizardPage) {
                ((AbstractWizardPage)page).saveWidgetValues();
            }
            if (page instanceof IDataExchangeNode) {
                ((IDataExchangeNode)page).extractData(peerAttributes);
            }
            ++n2;
        }
    }

    public boolean performFinish() {
        this.extractData(this.data);
        if (!this.data.containsKey("ID")) {
            this.data.setProperty("ID", (Object)UUID.randomUUID().toString());
        }
        if (!this.data.containsKey("Name")) {
            this.data.setProperty("Name", (Object)NLS.bind((String)Messages.NewTargetWizard_newPeer_name, (Object)counter.incrementAndGet()));
        }
        final HashMap<String, String> attrs = new HashMap<String, String>();
        for (Map.Entry entry : this.data.getProperties().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            attrs.put((String)entry.getKey(), entry.getValue() instanceof String ? (String)entry.getValue() : entry.getValue().toString());
        }
        try {
            IURIPersistenceService persistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
            if (persistenceService == null) {
                throw new IOException("Persistence service instance unavailable.");
            }
            persistenceService.write((Object)new Peer(attrs), null);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IPeerModelRefreshService service = (IPeerModelRefreshService)ModelManager.getPeerModel().getService(IPeerModelRefreshService.class);
                    if (service != null) {
                        service.refresh((ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                final IPeerNode peerNode = ((IPeerModelLookupService)ModelManager.getPeerModel().getService(IPeerModelLookupService.class)).lkupPeerModelById((String)attrs.get("ID"));
                                if (peerNode != null) {
                                    ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
                                    StructuredSelection selection = new StructuredSelection((Object)peerNode);
                                    ViewsUtil.setSelection((String)"org.eclipse.tcf.te.ui.views.View", (ISelection)selection);
                                    if (NewWizard.this.isOpenEditorOnPerformFinish()) {
                                        ViewsUtil.openEditor((ISelection)selection);
                                    }
                                    DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            NewWizard.this.postPerformFinish(peerNode);
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (IOException e) {
            if (this.getContainer().getCurrentPage() instanceof WizardPage) {
                String message = NLS.bind((String)Messages.NewTargetWizard_error_savePeer, (Object)e.getLocalizedMessage());
                ((WizardPage)this.getContainer().getCurrentPage()).setMessage(message, 3);
                this.getContainer().updateMessage();
            }
            return false;
        }
        return true;
    }

    @Override
    protected String getWizardTitle() {
        return Messages.NewTargetWizard_windowTitle;
    }
}

