/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.FunctionConcurrencyAnalysis;

public class FileConcurrencyAnalysis {
    protected IASTTranslationUnit astTransUnit_ = null;
    protected IFile iFile_ = null;
    protected PASTOMPPragma[] pragmas_ = null;
    protected FunctionConcurrencyAnalysis[] analyses_ = null;
    protected static final boolean traceOn = false;

    public FileConcurrencyAnalysis(IASTTranslationUnit astTransUnit, IFile iFile, PASTOMPPragma[] ompPragmas) {
        this.astTransUnit_ = astTransUnit;
        this.iFile_ = iFile;
        this.pragmas_ = ompPragmas;
        this.buildFileAnalysis();
    }

    public Set getNodesConcurrentTo(IASTNode node) {
        int i = 0;
        while (i < this.analyses_.length) {
            Set s = this.analyses_[i].getNodesConcurrentTo(node);
            if (s != null) {
                return s;
            }
            ++i;
        }
        return new HashSet();
    }

    protected void buildFileAnalysis() {
        DefVisitor dv = new DefVisitor(this.astTransUnit_, this.iFile_, this.pragmas_);
        this.analyses_ = dv.buildAnalyses();
        int i = 0;
        while (i < this.analyses_.length) {
            FunctionConcurrencyAnalysis oca = this.analyses_[i];
            oca.doPhaseAnalysis();
            ++i;
        }
    }

    private static class DefVisitor
    extends ASTVisitor {
        private IASTTranslationUnit transUnit_ = null;
        private IFile iFile_ = null;
        private PASTOMPPragma[] pList_ = null;
        private LinkedList analysisList_ = new LinkedList();

        public DefVisitor(IASTTranslationUnit transUnit, IFile iFile, PASTOMPPragma[] pList) {
            this.transUnit_ = transUnit;
            this.pList_ = pList;
            this.iFile_ = iFile;
        }

        public FunctionConcurrencyAnalysis[] buildAnalyses() {
            this.shouldVisitDeclarations = true;
            this.transUnit_.accept((ASTVisitor)this);
            FunctionConcurrencyAnalysis[] list = new FunctionConcurrencyAnalysis[this.analysisList_.size()];
            int count = 0;
            Iterator i = this.analysisList_.iterator();
            while (i.hasNext()) {
                list[count++] = (FunctionConcurrencyAnalysis)((Object)i.next());
            }
            return list;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTFunctionDefinition) {
                IASTFunctionDefinition fDef = (IASTFunctionDefinition)declaration;
                URI uri = this.iFile_.getLocationURI();
                String str2 = uri.getPath();
                String str1 = fDef.getContainingFilename();
                if (str1.equals(str2)) {
                    FunctionConcurrencyAnalysis analysis = new FunctionConcurrencyAnalysis(fDef, this.pList_);
                    this.analysisList_.add(analysis);
                }
            }
            return 3;
        }
    }
}

