/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNamespaceInformationCommand;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;

public abstract class UpdateComponentReferenceAndManageDirectivesCommand
extends BaseCommand {
    protected XSDConcreteComponent concreteComponent;
    protected String componentName;
    protected String componentNamespace;
    protected IFile file;
    private static final String PLATFORM_RESOURCE_PREFIX = "platform:/resource";

    public UpdateComponentReferenceAndManageDirectivesCommand(XSDConcreteComponent concreteComponent, String componentName, String componentNamespace, IFile file) {
        this.concreteComponent = concreteComponent;
        this.componentName = componentName;
        this.componentNamespace = componentNamespace;
        this.file = file;
    }

    protected XSDComponent computeComponent() {
        XSDComponent result = null;
        XSDSchema schema = this.concreteComponent.getSchema();
        XSDInclude directive = null;
        result = this.getDefinedComponent(schema, this.componentName, this.componentNamespace);
        if (result == null) {
            if (this.componentNamespace != null && this.componentNamespace.equals(schema.getTargetNamespace())) {
                directive = XSDFactory.eINSTANCE.createXSDInclude();
            } else if (this.componentNamespace == null) {
                directive = XSDFactory.eINSTANCE.createXSDInclude();
                if (schema.getSchemaForSchemaQNamePrefix() == null) {
                    String targetNS = schema.getTargetNamespace();
                    if (targetNS == null) {
                        targetNS = "";
                    }
                    UpdateNamespaceInformationCommand command = new UpdateNamespaceInformationCommand("", schema, "", targetNS);
                    command.execute();
                }
            } else {
                XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
                xsdImport.setNamespace(this.componentNamespace);
                directive = xsdImport;
            }
            String location = this.computeNiceLocation(schema.getSchemaLocation(), this.file);
            directive.setSchemaLocation(location);
            schema.getContents().add(0, (Object)directive);
            XSDSchema resolvedSchema = directive.getResolvedSchema();
            if (resolvedSchema == null) {
                String platformLocation = PLATFORM_RESOURCE_PREFIX + this.file.getFullPath();
                Resource resource = this.concreteComponent.eResource().getResourceSet().createResource(URI.createURI((String)platformLocation));
                if (resource instanceof XSDResourceImpl) {
                    try {
                        resource.load(null);
                        XSDResourceImpl resourceImpl = (XSDResourceImpl)resource;
                        resolvedSchema = resourceImpl.getSchema();
                        if (resolvedSchema != null) {
                            directive.setResolvedSchema(resolvedSchema);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (resolvedSchema != null) {
                result = this.getDefinedComponent(resolvedSchema, this.componentName, this.componentNamespace);
            }
        }
        return result;
    }

    private String computeNiceLocation(String baseLocation, IFile file) {
        if (baseLocation.startsWith(PLATFORM_RESOURCE_PREFIX)) {
            URI baseURI = URI.createURI((String)baseLocation);
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString());
            URI relative = fileURI.deresolve(baseURI, false, true, true);
            return relative.toString();
        }
        URI baseURI = URI.createURI((String)baseLocation);
        URI fileURI = URI.createFileURI((String)file.getLocation().toOSString());
        URI relative = fileURI.deresolve(baseURI, false, true, true);
        return relative.toString();
    }

    protected abstract XSDComponent getDefinedComponent(XSDSchema var1, String var2, String var3);

    public abstract void execute();
}

