/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumArgumentsProvider;
import org.junit.jupiter.params.provider.EnumSources;
import org.junit.jupiter.params.provider.NullEnum;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Repeatable(value=EnumSources.class)
@API(status=API.Status.STABLE, since="5.7")
@ArgumentsSource(value=EnumArgumentsProvider.class)
public @interface EnumSource {
    public Class<? extends Enum<?>> value() default NullEnum.class;

    public String[] names() default {};

    public Mode mode() default Mode.INCLUDE;

    public static enum Mode {
        INCLUDE(Mode::validateNames, (name, names) -> names.contains(name)),
        EXCLUDE(Mode::validateNames, (name, names) -> !names.contains(name)),
        MATCH_ALL(Mode::validatePatterns, (name, patterns) -> patterns.stream().allMatch(name::matches)),
        MATCH_ANY(Mode::validatePatterns, (name, patterns) -> patterns.stream().anyMatch(name::matches)),
        MATCH_NONE(Mode::validatePatterns, (name, patterns) -> patterns.stream().noneMatch(name::matches));

        private final Validator validator;
        private final BiPredicate<String, Set<String>> selector;

        private Mode(Validator validator, BiPredicate<String, Set<String>> selector) {
            this.validator = validator;
            this.selector = selector;
        }

        void validate(EnumSource enumSource, Set<? extends Enum<?>> constants, Set<String> names) {
            Preconditions.notNull((Object)enumSource, (String)"EnumSource must not be null");
            Preconditions.notNull(names, (String)"names must not be null");
            this.validator.validate(enumSource, constants, names);
        }

        boolean select(Enum<?> constant, Set<String> names) {
            Preconditions.notNull(constant, (String)"Enum constant must not be null");
            Preconditions.notNull(names, (String)"names must not be null");
            return this.selector.test(constant.name(), names);
        }

        private static void validateNames(EnumSource enumSource, Set<? extends Enum<?>> constants, Set<String> names) {
            Set allNames = constants.stream().map(Enum::name).collect(Collectors.toSet());
            Preconditions.condition((boolean)allNames.containsAll(names), () -> "Invalid enum constant name(s) in " + enumSource + ". Valid names include: " + allNames);
        }

        private static void validatePatterns(EnumSource enumSource, Set<? extends Enum<?>> constants, Set<String> names) {
            try {
                names.forEach(Pattern::compile);
            }
            catch (PatternSyntaxException e) {
                throw new PreconditionViolationException("Pattern compilation failed for a regular expression supplied in " + enumSource, (Throwable)e);
            }
        }

        private static interface Validator {
            public void validate(EnumSource var1, Set<? extends Enum<?>> var2, Set<String> var3);
        }
    }
}

