/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchTag;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;

public class LoadTagsIndication
extends CDOServerReadIndication {
    private String name;

    public LoadTagsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)63);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.name = in.readString();
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        if (this.name != null) {
            CDOBranchTag tag = branchManager.getTag(this.name);
            if (tag != null) {
                out.writeBoolean(true);
                out.writeCDOBranchPoint((CDOBranchPoint)tag);
            } else {
                out.writeBoolean(false);
            }
        } else {
            CDOBranchManager.CDOTagList tagList = branchManager.getTagList();
            CDOBranchTag[] tags = tagList.getTags();
            int count = tags.length;
            out.writeXInt(count);
            int i = 0;
            while (i < count) {
                CDOBranchTag tag = tags[i];
                out.writeString(tag.getName());
                out.writeCDOBranchPoint((CDOBranchPoint)tag);
                ++i;
            }
        }
    }
}

