/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.InitializeException;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldFunction;
import io.github.toolfactory.jvm.function.catalog.SetAccessibleFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.Supplier;
import io.github.toolfactory.jvm.function.template.TriConsumer;
import io.github.toolfactory.jvm.util.Classes;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import io.github.toolfactory.narcissus.Narcissus;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import sun.misc.Unsafe;

public interface SetFieldValueFunction
extends TriConsumer<Object, Field, Object> {

    public static interface Native
    extends SetFieldValueFunction {

        public static class ForJava7
        extends Abst
        implements Native {
            public ForJava7(Map<Object, Object> context) throws InitializeException {
                super(context);
                this.checkNativeEngine();
            }

            protected void checkNativeEngine() throws InitializeException {
                if (!Narcissus.libraryLoaded) {
                    throw new InitializeException(Strings.compile("Could not initialize the native engine {}", Narcissus.class.getName()));
                }
            }

            @Override
            public void accept(Object target, Field field, Object value) {
                if (value != null && !Classes.isAssignableFrom(field.getType(), value.getClass())) {
                    throw new IllegalArgumentException(Strings.compile("Value {} is not assignable to {}", value, field.getName()));
                }
                if (Modifier.isStatic(field.getModifiers())) {
                    Narcissus.setStaticField((Field)field, (Object)value);
                } else {
                    Narcissus.setField((Object)target, (Field)field, (Object)value);
                }
            }
        }
    }

    public static class ForJava25
    extends ForJava7 {
        protected ThrowExceptionFunction throwExceptionFunction;
        protected Field modifiersField;
        protected GetDeclaredFieldFunction getDeclaredFieldFunction;
        protected Supplier<GetDeclaredFieldFunction> getDeclaredFieldFunctionSupplier;
        protected SetAccessibleFunction setAccessibleFunction;
        protected Supplier<SetAccessibleFunction> setAccessibleFunctionSupplier;

        public ForJava25(final Map<Object, Object> context) throws Throwable {
            super(context);
            this.throwExceptionFunction = ObjectProvider.get(context).getOrBuildObject(ThrowExceptionFunction.class, context);
            this.setAccessibleFunctionSupplier = new Supplier<SetAccessibleFunction>(){

                @Override
                public SetAccessibleFunction get() {
                    return ObjectProvider.get(context).getOrBuildObject(SetAccessibleFunction.class, context);
                }
            };
            this.getDeclaredFieldFunctionSupplier = new Supplier<GetDeclaredFieldFunction>(){

                @Override
                public GetDeclaredFieldFunction get() {
                    return ObjectProvider.get(context).getOrBuildObject(GetDeclaredFieldFunction.class, context);
                }
            };
        }

        @Override
        public void accept(Object origTarget, Field field, Object value) {
            Object target;
            Class<?> fieldType = field.getType();
            if (value != null && !Classes.isAssignableFrom(fieldType, value.getClass())) {
                throw new IllegalArgumentException(Strings.compile("Value {} is not assignable to {}", value, field.getName()));
            }
            Class<?> fieldDeclaringClass = field.getDeclaringClass();
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (isStatic) {
                target = fieldDeclaringClass;
            } else {
                target = origTarget;
                if (target == null) {
                    throw new IllegalArgumentException("Target object is null");
                }
                Class<?> targetObjectClass = target.getClass();
                if (!Classes.isAssignableFrom(fieldDeclaringClass, targetObjectClass)) {
                    throw new IllegalArgumentException("Target object class " + targetObjectClass + " is not assignable to " + fieldDeclaringClass);
                }
            }
            try {
                Long fieldOffset = isStatic ? Long.valueOf(this.unsafe.staticFieldOffset(field)) : Long.valueOf(this.unsafe.objectFieldOffset(field));
                this.setByUnsafe(field, value, fieldOffset, target, field.getType());
            }
            catch (UnsupportedOperationException exc) {
                try {
                    this.setByReflection(field, fieldType, isStatic, target, value);
                }
                catch (Throwable exc2) {
                    this.throwExceptionFunction.accept(exc2);
                }
            }
        }

        protected void setByReflection(Field field, Class<?> fieldType, boolean isStatic, Object target, Object value) throws Throwable {
            this.setAccessible(field);
            int initialModifiers = field.getModifiers();
            Field modifiersField = null;
            if (Modifier.isFinal(initialModifiers)) {
                modifiersField = this.removeFinalFlag(field, initialModifiers);
            }
            if (isStatic) {
                field.set(null, value);
            } else {
                field.set(target, value);
            }
            if (modifiersField != null) {
                modifiersField.setInt(field, initialModifiers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAccessible(AccessibleObject accessibleObject) throws Throwable {
            try {
                this.setAccessibleFunction.accept(accessibleObject, true);
            }
            catch (NullPointerException exc) {
                if (this.setAccessibleFunction == null) {
                    ForJava25 forJava25 = this;
                    synchronized (forJava25) {
                        if (this.setAccessibleFunction == null) {
                            this.init();
                        }
                    }
                    this.setAccessible(accessibleObject);
                }
                this.throwExceptionFunction.accept(exc);
            }
        }

        protected void init() throws Throwable {
            this.setAccessibleFunction = this.setAccessibleFunctionSupplier.get();
            this.getDeclaredFieldFunction = this.getDeclaredFieldFunctionSupplier.get();
            this.modifiersField = (Field)this.getDeclaredFieldFunction.apply(Field.class, "modifiers");
            this.setAccessible(this.modifiersField);
        }

        protected Field removeFinalFlag(Field field, int currentValue) throws IllegalAccessException {
            this.modifiersField.setInt(field, currentValue & 0xFFFFFFEF);
            return this.modifiersField;
        }
    }

    public static class ForJava7
    extends Abst {
        final Unsafe unsafe;

        public ForJava7(Map<Object, Object> context) {
            super(context);
            this.unsafe = (Unsafe)ObjectProvider.get(context).getOrBuildObject(UnsafeSupplier.class, context).get();
        }

        @Override
        public void accept(Object origTarget, Field field, Object value) {
            Class<?> target;
            long fieldOffset;
            if (value != null && !Classes.isAssignableFrom(field.getType(), value.getClass())) {
                throw new IllegalArgumentException(Strings.compile("Value {} is not assignable to {}", value, field.getName()));
            }
            Class<?> fieldDeclaringClass = field.getDeclaringClass();
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (isStatic) {
                fieldOffset = this.unsafe.staticFieldOffset(field);
                target = fieldDeclaringClass;
            } else {
                target = origTarget;
                if (target == null) {
                    throw new IllegalArgumentException("Target object is null");
                }
                Class<?> targetObjectClass = target.getClass();
                if (!Classes.isAssignableFrom(fieldDeclaringClass, targetObjectClass)) {
                    throw new IllegalArgumentException("Target object class " + targetObjectClass + " is not assignable to " + fieldDeclaringClass);
                }
                fieldOffset = this.unsafe.objectFieldOffset(field);
            }
            this.setByUnsafe(field, value, fieldOffset, target, field.getType());
        }

        protected void setByUnsafe(Field field, Object value, long fieldOffset, Object target, Class<?> cls) {
            if (!cls.isPrimitive()) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putObject(target, fieldOffset, value);
                } else {
                    this.unsafe.putObjectVolatile(target, fieldOffset, value);
                }
            } else if (cls == Short.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putShort(target, fieldOffset, (Short)value);
                } else {
                    this.unsafe.putShortVolatile(target, fieldOffset, (Short)value);
                }
            } else if (cls == Integer.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putInt(target, fieldOffset, (Integer)value);
                } else {
                    this.unsafe.putIntVolatile(target, fieldOffset, (Integer)value);
                }
            } else if (cls == Long.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putLong(target, fieldOffset, (Long)value);
                } else {
                    this.unsafe.putLongVolatile(target, fieldOffset, (Long)value);
                }
            } else if (cls == Float.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putFloat(target, fieldOffset, ((Float)value).floatValue());
                } else {
                    this.unsafe.putFloatVolatile(target, fieldOffset, ((Float)value).floatValue());
                }
            } else if (cls == Double.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putDouble(target, fieldOffset, (Double)value);
                } else {
                    this.unsafe.putDoubleVolatile(target, fieldOffset, (Double)value);
                }
            } else if (cls == Boolean.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putBoolean(target, fieldOffset, (Boolean)value);
                } else {
                    this.unsafe.putBooleanVolatile(target, fieldOffset, (Boolean)value);
                }
            } else if (cls == Byte.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putByte(target, fieldOffset, (Byte)value);
                } else {
                    this.unsafe.putByteVolatile(target, fieldOffset, (Byte)value);
                }
            } else if (cls == Character.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    this.unsafe.putChar(target, fieldOffset, ((Character)value).charValue());
                } else {
                    this.unsafe.putCharVolatile(target, fieldOffset, ((Character)value).charValue());
                }
            }
        }
    }

    public static abstract class Abst
    implements SetFieldValueFunction {
        public Abst(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
        }
    }
}

