/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.annotation.Contract;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public final class Preconditions {
    private Preconditions() {
    }

    @Contract(value="null, _ -> fail; !null, _ -> param1")
    public static <T> T notNull(@Nullable T object, String message) throws PreconditionViolationException {
        Preconditions.condition(object != null, message);
        return object;
    }

    @Contract(value="null, _ -> fail; !null, _ -> param1")
    public static <T> T notNull(@Nullable T object, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(object != null, messageSupplier);
        return object;
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    @Contract(value="null, _ -> fail")
    public static int[] notEmpty(int @Nullable [] array, String message) throws PreconditionViolationException {
        Preconditions.condition(array != null && array.length > 0, message);
        return array;
    }

    @Contract(value="null, _ -> fail")
    public static <T> T[] notEmpty(T @Nullable [] array, String message) throws PreconditionViolationException {
        Preconditions.condition(array != null && array.length > 0, message);
        return array;
    }

    @Contract(value="null, _ -> fail")
    public static <T> T[] notEmpty(T @Nullable [] array, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(array != null && array.length > 0, messageSupplier);
        return array;
    }

    @Contract(value="null, _ -> fail")
    public static <T extends Collection<?>> T notEmpty(@Nullable T collection, String message) throws PreconditionViolationException {
        Preconditions.condition(collection != null && !collection.isEmpty(), message);
        return collection;
    }

    @Contract(value="null, _ -> fail")
    public static <T extends Collection<?>> T notEmpty(@Nullable T collection, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(collection != null && !collection.isEmpty(), messageSupplier);
        return collection;
    }

    @Contract(value="null, _ -> null")
    public static <T> T @Nullable [] containsNoNullElements(T @Nullable [] array, String message) throws PreconditionViolationException {
        if (array != null) {
            Arrays.stream(array).forEach(object -> Preconditions.notNull(object, message));
        }
        return array;
    }

    @Contract(value="null, _ -> null")
    public static <T> T @Nullable [] containsNoNullElements(T @Nullable [] array, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (array != null) {
            Arrays.stream(array).forEach(object -> Preconditions.notNull(object, messageSupplier));
        }
        return array;
    }

    @Contract(value="null, _ -> null")
    public static <T extends Collection<?>> @Nullable T containsNoNullElements(@Nullable T collection, String message) throws PreconditionViolationException {
        if (collection != null) {
            collection.forEach(object -> Preconditions.notNull(object, message));
        }
        return (T)collection;
    }

    @Contract(value="null, _ -> null")
    public static <T extends Collection<?>> @Nullable T containsNoNullElements(@Nullable T collection, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (collection != null) {
            collection.forEach(object -> Preconditions.notNull(object, messageSupplier));
        }
        return (T)collection;
    }

    @Contract(value="null, _ -> fail")
    public static String notBlank(@Nullable String str, String message) throws PreconditionViolationException {
        Preconditions.condition(StringUtils.isNotBlank(str), message);
        return str;
    }

    @Contract(value="null, _ -> fail")
    public static String notBlank(@Nullable String str, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(StringUtils.isNotBlank(str), messageSupplier);
        return str;
    }

    @Contract(value="false, _ -> fail")
    public static void condition(boolean predicate, String message) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(message);
        }
    }

    @Contract(value="false, _ -> fail")
    public static void condition(boolean predicate, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
    }
}

