/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.provider;

import java.util.ArrayList;
import org.eclipse.cdt.core.index.provider.IPDOMDescriptor;
import org.eclipse.cdt.core.index.provider.IReadOnlyPDOMProvider;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.provider.IIndexFragmentProvider;
import org.eclipse.cdt.internal.core.index.provider.PDOMCache;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.core.runtime.CoreException;

public class ReadOnlyPDOMProviderBridge
implements IIndexFragmentProvider {
    private final IReadOnlyPDOMProvider provider;

    public ReadOnlyPDOMProviderBridge(IReadOnlyPDOMProvider provider) {
        this.provider = provider;
    }

    @Override
    public IIndexFragment[] getIndexFragments(ICConfigurationDescription config) throws CoreException {
        ArrayList<PDOM> result = new ArrayList<PDOM>();
        IPDOMDescriptor[] descriptions = this.provider.getDescriptors(config);
        if (descriptions != null) {
            IPDOMDescriptor[] iPDOMDescriptorArray = descriptions;
            int n = descriptions.length;
            int n2 = 0;
            while (n2 < n) {
                IPDOMDescriptor desc = iPDOMDescriptorArray[n2];
                PDOM pdom = PDOMCache.getInstance().getPDOM(desc.getLocation(), desc.getIndexLocationConverter());
                if (pdom != null) {
                    result.add(pdom);
                }
                ++n2;
            }
        }
        return result.toArray(new IIndexFragment[result.size()]);
    }

    @Override
    public boolean providesFor(ICProject cproject) throws CoreException {
        return this.provider.providesFor(cproject);
    }
}

