/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.debug;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.debugger.breakpoint.SPLineBreakpoint;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.debug.BreakpointLocationVerifierJob;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class BreakpointLocationHandler {
    public static void handleNewBreakpoint(SPLineBreakpoint breakpoint, ProcIdentifier proc, int lineNumber, IEditorPart editor) {
        if (editor.isDirty()) {
            return;
        }
        try {
            new BreakpointLocationVerifierJob(breakpoint, (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class)).schedule();
        }
        catch (CoreException e) {
            DebuggerCorePlugin.getDefault().log((Throwable)e);
        }
    }

    public static void handleEditorSave(ProcIdentifier proc, IEditorPart editor) {
        List breakpoints = SPDebugModelUtil.findAllSPLineBreakpointForSP((ProcIdentifier)proc);
        if (breakpoints == null || breakpoints.isEmpty()) {
            return;
        }
        SPLineBreakpoint[] bps = breakpoints.toArray(new SPLineBreakpoint[breakpoints.size()]);
        new BreakpointLocationVerifierJob(proc, bps, (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class)).schedule();
    }
}

