/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.storage.GitBlobStorage;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class CommitBlobStorage
extends GitBlobStorage {
    private final RevCommit commit;

    public CommitBlobStorage(Repository repository, String fileName, ObjectId blob, RevCommit commit, DirCacheCheckout.CheckoutMetadata metadata) {
        super(repository, fileName, blob, metadata);
        this.commit = commit;
    }

    @Override
    public IPath getFullPath() {
        Path repoPath = new Path(RepositoryUtil.INSTANCE.getRepositoryName(this.db));
        String pathString = super.getFullPath().toPortableString() + " " + Utils.getShortObjectId(this.commit.getId());
        return repoPath.append(Path.fromPortableString((String)pathString));
    }

    @Override
    public GitInfo.Source getSource() {
        return GitInfo.Source.COMMIT;
    }

    @Override
    public AnyObjectId getCommitId() {
        return this.commit;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 * super.hashCode() + (this.commit == null ? 0 : this.commit.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommitBlobStorage other = (CommitBlobStorage)obj;
        return !(this.commit == null ? other.commit != null : !this.commit.equals((AnyObjectId)other.commit));
    }
}

