/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOUserSavepointImpl;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.collection.MultiMap;
import org.eclipse.net4j.util.concurrent.CriticalSection;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class CDOSavepointImpl
extends CDOUserSavepointImpl
implements InternalCDOSavepoint {
    private final InternalCDOTransaction transaction;
    private Map<CDOID, CDORevision> baseNewObjects = CDOIDUtil.createMap();
    private Map<CDOID, CDOObject> newObjects = CDOIDUtil.createMap();
    private Map<CDOID, CDOObject> reattachedObjects = CDOIDUtil.createMap();
    private Map<CDOID, CDOObject> detachedObjects = new HashMap<CDOID, CDOObject>(){
        private static final long serialVersionUID = 1L;

        @Override
        public CDOObject put(CDOID key, CDOObject object) {
            return (CDOObject)CDOSavepointImpl.this.sync().supply(() -> {
                CDOSavepointImpl.this.baseNewObjects.remove(key);
                CDOSavepointImpl.this.newObjects.remove(key);
                CDOSavepointImpl.this.reattachedObjects.remove(key);
                CDOSavepointImpl.this.dirtyObjects.remove(key);
                CDOSavepointImpl.this.revisionDeltas.remove(key);
                return super.put(key, object);
            });
        }
    };
    private Map<CDOID, CDOObject> dirtyObjects = CDOIDUtil.createMap();
    private Map<CDOID, CDORevisionDelta> revisionDeltas = new HashMap<CDOID, CDORevisionDelta>(){
        private static final long serialVersionUID = 1L;

        @Override
        public CDORevisionDelta put(CDOID id, CDORevisionDelta delta) {
            CDOSavepointImpl.this.transaction.clearResourcePathCacheIfNecessary(delta);
            return super.put(id, delta);
        }

        @Override
        public void putAll(Map<? extends CDOID, ? extends CDORevisionDelta> m) {
            throw new UnsupportedOperationException();
        }
    };
    private boolean wasDirty;

    public CDOSavepointImpl(InternalCDOTransaction transaction, InternalCDOSavepoint lastSavepoint) {
        super(transaction, lastSavepoint);
        this.transaction = transaction;
        this.wasDirty = transaction.isDirty();
    }

    @Override
    public InternalCDOTransaction getTransaction() {
        return (InternalCDOTransaction)super.getTransaction();
    }

    @Override
    public InternalCDOSavepoint getFirstSavePoint() {
        return (InternalCDOSavepoint)this.sync().supply(() -> (InternalCDOSavepoint)super.getFirstSavePoint());
    }

    @Override
    public InternalCDOSavepoint getPreviousSavepoint() {
        return (InternalCDOSavepoint)this.sync().supply(() -> (InternalCDOSavepoint)super.getPreviousSavepoint());
    }

    @Override
    public InternalCDOSavepoint getNextSavepoint() {
        return (InternalCDOSavepoint)this.sync().supply(() -> (InternalCDOSavepoint)super.getNextSavepoint());
    }

    @Override
    public void clear() {
        this.sync().run(() -> {
            this.newObjects.clear();
            this.dirtyObjects.clear();
            this.revisionDeltas.clear();
            this.baseNewObjects.clear();
            this.detachedObjects.clear();
            this.reattachedObjects.clear();
        });
    }

    @Override
    public boolean wasDirty() {
        return this.wasDirty;
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        return this.newObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getDetachedObjects() {
        return this.detachedObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getReattachedObjects() {
        return this.reattachedObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        return this.dirtyObjects;
    }

    @Override
    @Deprecated
    public Set<CDOID> getSharedDetachedObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void recalculateSharedDetachedObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ConcurrentMap<CDOID, CDORevisionDelta> getRevisionDeltas() {
        return new ConcurrentMap<CDOID, CDORevisionDelta>(){

            @Override
            public int size() {
                return CDOSavepointImpl.this.revisionDeltas.size();
            }

            @Override
            public boolean isEmpty() {
                return CDOSavepointImpl.this.revisionDeltas.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return CDOSavepointImpl.this.revisionDeltas.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return CDOSavepointImpl.this.revisionDeltas.containsValue(value);
            }

            @Override
            public CDORevisionDelta get(Object key) {
                return (CDORevisionDelta)CDOSavepointImpl.this.revisionDeltas.get(key);
            }

            @Override
            public CDORevisionDelta put(CDOID key, CDORevisionDelta value) {
                return CDOSavepointImpl.this.revisionDeltas.put(key, value);
            }

            @Override
            public CDORevisionDelta remove(Object key) {
                return (CDORevisionDelta)CDOSavepointImpl.this.revisionDeltas.remove(key);
            }

            @Override
            public void putAll(Map<? extends CDOID, ? extends CDORevisionDelta> m) {
                CDOSavepointImpl.this.revisionDeltas.putAll(m);
            }

            @Override
            public void clear() {
                CDOSavepointImpl.this.revisionDeltas.clear();
            }

            @Override
            public Set<CDOID> keySet() {
                return CDOSavepointImpl.this.revisionDeltas.keySet();
            }

            @Override
            public Collection<CDORevisionDelta> values() {
                return CDOSavepointImpl.this.revisionDeltas.values();
            }

            @Override
            public Set<Map.Entry<CDOID, CDORevisionDelta>> entrySet() {
                return CDOSavepointImpl.this.revisionDeltas.entrySet();
            }

            @Override
            public boolean equals(Object o) {
                return CDOSavepointImpl.this.revisionDeltas.equals(o);
            }

            @Override
            public int hashCode() {
                return CDOSavepointImpl.this.revisionDeltas.hashCode();
            }

            @Override
            public CDORevisionDelta putIfAbsent(CDOID key, CDORevisionDelta value) {
                return null;
            }

            @Override
            public boolean remove(Object key, Object value) {
                return false;
            }

            @Override
            public boolean replace(CDOID key, CDORevisionDelta oldValue, CDORevisionDelta newValue) {
                return false;
            }

            @Override
            public CDORevisionDelta replace(CDOID key, CDORevisionDelta value) {
                return null;
            }
        };
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getRevisionDeltas2() {
        return this.revisionDeltas;
    }

    public CDOChangeSetData getChangeSetData() {
        return (CDOChangeSetData)this.sync().supply(() -> this.createChangeSetData(this.newObjects, this.revisionDeltas, this.detachedObjects));
    }

    @Override
    public CDOChangeSetData getAllChangeSetData() {
        return (CDOChangeSetData)this.sync().supply(() -> this.createChangeSetData(this.getAllNewObjects(), this.getAllRevisionDeltas(), this.getAllDetachedObjects()));
    }

    private CDOChangeSetData createChangeSetData(Map<CDOID, CDOObject> newObjects, Map<CDOID, CDORevisionDelta> revisionDeltas, Map<CDOID, CDOObject> detachedObjects) {
        ArrayList<CDORevision> newList = new ArrayList<CDORevision>(newObjects.size());
        for (CDOObject object : newObjects.values()) {
            newList.add(object.cdoRevision());
        }
        ArrayList<CDORevisionDelta> changedList = new ArrayList<CDORevisionDelta>(revisionDeltas.size());
        for (CDORevisionDelta delta : revisionDeltas.values()) {
            changedList.add(delta);
        }
        ArrayList<CDOIDAndVersion> detachedList = new ArrayList<CDOIDAndVersion>(detachedObjects.size());
        for (CDOID id : detachedObjects.keySet()) {
            detachedList.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)0));
        }
        return new CDOChangeSetDataImpl(newList, changedList, detachedList);
    }

    @Override
    public Map<CDOID, CDORevision> getBaseNewObjects() {
        return this.baseNewObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getAllDirtyObjects() {
        return (Map)this.sync().supply(() -> {
            if (this.getPreviousSavepoint() == null) {
                return Collections.unmodifiableMap(this.getDirtyObjects());
            }
            MultiMap.ListBased dirtyObjects = new MultiMap.ListBased();
            InternalCDOSavepoint savepoint = this;
            while (savepoint != null) {
                dirtyObjects.getDelegates().add(savepoint.getDirtyObjects());
                savepoint = savepoint.getPreviousSavepoint();
            }
            return dirtyObjects;
        });
    }

    @Override
    public Map<CDOID, CDOObject> getAllNewObjects() {
        return (Map)this.sync().supply(() -> {
            if (this.getPreviousSavepoint() == null) {
                return Collections.unmodifiableMap(this.getNewObjects());
            }
            Map newObjects = CDOIDUtil.createMap();
            InternalCDOSavepoint savepoint = this.getFirstSavePoint();
            while (savepoint != null) {
                newObjects.putAll(savepoint.getNewObjects());
                for (CDOID removedID : savepoint.getDetachedObjects().keySet()) {
                    newObjects.remove(removedID);
                }
                savepoint = savepoint.getNextSavepoint();
            }
            return newObjects;
        });
    }

    @Override
    public Map<CDOID, CDORevision> getAllBaseNewObjects() {
        return (Map)this.sync().supply(() -> {
            if (this.getPreviousSavepoint() == null) {
                return Collections.unmodifiableMap(this.getBaseNewObjects());
            }
            MultiMap.ListBased newObjects = new MultiMap.ListBased();
            InternalCDOSavepoint savepoint = this;
            while (savepoint != null) {
                newObjects.getDelegates().add(savepoint.getBaseNewObjects());
                savepoint = savepoint.getPreviousSavepoint();
            }
            return newObjects;
        });
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getAllRevisionDeltas() {
        return (Map)this.sync().supply(() -> {
            if (this.getPreviousSavepoint() == null) {
                return Collections.unmodifiableMap(this.getRevisionDeltas2());
            }
            InternalCDOSavepoint firstSavePoint = this.getFirstSavePoint();
            boolean multiSavepoint = firstSavePoint.getNextSavepoint() != null;
            HashSet<CDOFeatureDelta> originalFeatureDeltas = multiSavepoint ? new HashSet<CDOFeatureDelta>() : null;
            Map allRevisionDeltas = CDOIDUtil.createMap();
            InternalCDOSavepoint savepoint = firstSavePoint;
            while (savepoint != null) {
                for (CDORevisionDelta revisionDelta : savepoint.getRevisionDeltas2().values()) {
                    CDOID id = revisionDelta.getID();
                    if (this.isNewObject(id)) continue;
                    CDORevisionDeltaImpl oldRevisionDelta = (CDORevisionDeltaImpl)allRevisionDeltas.get(id);
                    if (oldRevisionDelta == null) {
                        if (multiSavepoint) {
                            for (CDOFeatureDelta featureDelta : revisionDelta.getFeatureDeltas()) {
                                originalFeatureDeltas.add(featureDelta);
                            }
                        }
                        allRevisionDeltas.put(id, revisionDelta.copy());
                        continue;
                    }
                    for (CDOFeatureDelta featureDelta : revisionDelta.getFeatureDeltas()) {
                        if (multiSavepoint && !originalFeatureDeltas.add(featureDelta)) continue;
                        CDOFeatureDelta copy = featureDelta.copy();
                        oldRevisionDelta.addFeatureDelta(copy, null);
                    }
                }
                Set<CDOID> reattachedObjects = savepoint.getReattachedObjects().keySet();
                for (CDOID detachedID : savepoint.getDetachedObjects().keySet()) {
                    if (reattachedObjects.contains(detachedID)) continue;
                    allRevisionDeltas.remove(detachedID);
                }
                savepoint = savepoint.getNextSavepoint();
            }
            return Collections.unmodifiableMap(allRevisionDeltas);
        });
    }

    @Override
    public Map<CDOID, CDOObject> getAllDetachedObjects() {
        return (Map)this.sync().supply(() -> {
            if (this.getPreviousSavepoint() == null && this.getReattachedObjects().isEmpty()) {
                return Collections.unmodifiableMap(this.getDetachedObjects());
            }
            Map detachedObjects = CDOIDUtil.createMap();
            InternalCDOSavepoint savepoint = this.getFirstSavePoint();
            while (savepoint != null) {
                for (Map.Entry<CDOID, CDOObject> entry : savepoint.getDetachedObjects().entrySet()) {
                    CDOID detachedID = entry.getKey();
                    if (this.isNewObject(detachedID)) continue;
                    CDOObject detachedObject = entry.getValue();
                    detachedObjects.put(detachedID, detachedObject);
                }
                Map<CDOID, CDOObject> reattachedObjects = savepoint.getReattachedObjects();
                for (CDOID reattachedID : reattachedObjects.keySet()) {
                    detachedObjects.remove(reattachedID);
                }
                savepoint = savepoint.getNextSavepoint();
            }
            return detachedObjects;
        });
    }

    @Override
    public boolean isNewObject(CDOID id) {
        if (id.isTemporary()) {
            return true;
        }
        return this.sync().supply(() -> {
            InternalCDOSavepoint savepoint = this;
            while (savepoint != null) {
                if (savepoint.getNewObjects().containsKey(id)) {
                    return true;
                }
                savepoint = savepoint.getPreviousSavepoint();
            }
            return false;
        });
    }

    @Override
    public CDOObject getDetachedObject(CDOID id) {
        return (CDOObject)this.sync().supply(() -> {
            InternalCDOSavepoint savepoint = this;
            while (savepoint != null) {
                CDOObject object;
                CDOObject object2;
                Map<CDOID, CDOObject> reattachedObjects = savepoint.getReattachedObjects();
                if (!reattachedObjects.isEmpty() && (object2 = reattachedObjects.get(id)) != null) {
                    return null;
                }
                Map<CDOID, CDOObject> detachedObjects = savepoint.getDetachedObjects();
                if (!detachedObjects.isEmpty() && (object = detachedObjects.get(id)) != null) {
                    return object;
                }
                savepoint = savepoint.getPreviousSavepoint();
            }
            return null;
        });
    }

    @Override
    public CDOObject getDirtyObject(CDOID id) {
        return (CDOObject)this.sync().supply(() -> {
            InternalCDOSavepoint savepoint = this;
            while (savepoint != null) {
                CDOObject object;
                Map<CDOID, CDOObject> dirtyObjects = savepoint.getDirtyObjects();
                if (!dirtyObjects.isEmpty() && (object = dirtyObjects.get(id)) != null) {
                    return object;
                }
                savepoint = savepoint.getPreviousSavepoint();
            }
            return null;
        });
    }

    @Override
    public void rollback() {
        this.sync().run(() -> {
            InternalCDOTransaction transaction = this.getTransaction();
            LifecycleUtil.checkActive((Object)transaction);
            CDOTransactionStrategy transactionStrategy = transaction.getTransactionStrategy();
            transactionStrategy.rollback(transaction, this);
        });
    }

    private CriticalSection sync() {
        return this.transaction.sync();
    }
}

