/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryPackParser;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.transport.PackParser;
import org.kohsuke.args4j.Option;

@Command(usage="usage_IndexPack")
class IndexPack
extends TextBuiltin {
    @Option(name="--fix-thin", usage="usage_fixAThinPackToBeComplete")
    private boolean fixThin;
    @Option(name="--index-version", usage="usage_indexFileFormatToCreate")
    private int indexVersion = -1;

    IndexPack() {
    }

    @Override
    protected void run() {
        BufferedInputStream in = new BufferedInputStream(this.ins);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectInserter inserter = this.db.newObjectInserter();){
                PackParser p = inserter.newPackParser((InputStream)in);
                p.setAllowThin(this.fixThin);
                if (this.indexVersion != -1 && p instanceof ObjectDirectoryPackParser) {
                    ObjectDirectoryPackParser imp = (ObjectDirectoryPackParser)p;
                    imp.setIndexVersion(this.indexVersion);
                }
                p.parse((ProgressMonitor)new TextProgressMonitor((Writer)this.errw));
                inserter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw IndexPack.die(e.getMessage(), (Throwable)e);
        }
    }
}

