/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.m2m.atl.emftvm.util.LazyBag;
import org.eclipse.m2m.atl.emftvm.util.LazyBagOnCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnList;
import org.eclipse.m2m.atl.emftvm.util.LazyOrderedSet;
import org.eclipse.m2m.atl.emftvm.util.LazySet;
import org.eclipse.m2m.atl.emftvm.util.LazySetOnSet;

public final class LazyCollections {
    private LazyCollections() {
    }

    public static <T> LazyList<T> asLazyList(Collection<T> source) {
        if (source instanceof LazyCollection) {
            return ((LazyCollection)source).asSequence();
        }
        if (source instanceof List) {
            return new LazyListOnList((List)source);
        }
        return new LazyListOnCollection<T>(source);
    }

    public static <T> LazyOrderedSet<T> asLazyOrderedSet(Collection<T> source) {
        if (source instanceof LazyCollection) {
            return ((LazyCollection)source).asOrderedSet();
        }
        return new LazyOrderedSet<T>(source);
    }

    public static <T> LazyBag<T> asLazyBag(Collection<T> source) {
        if (source instanceof LazyCollection) {
            return ((LazyCollection)source).asBag();
        }
        return new LazyBagOnCollection<T>(source);
    }

    public static <T> LazySet<T> asLazySet(Collection<T> source) {
        if (source instanceof LazyCollection) {
            return ((LazyCollection)source).asSet();
        }
        if (source instanceof Set) {
            return new LazySetOnSet((Set)source);
        }
        return new LazySet<T>(source);
    }
}

