/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.UniqueList;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartitioningStrategy;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractSimplePartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.NonPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class ReachabilityPartitioningStrategy
extends AbstractPartitioningStrategy {
    protected final @NonNull Region region;
    private final @NonNull Iterable<@NonNull Node> originalNodes;
    private final @NonNull Iterable<@NonNull Edge> originalEdges;
    private final @NonNull List<@NonNull AbstractReachabilityPartitionFactory> partitionFactories = new ArrayList<AbstractReachabilityPartitionFactory>();
    private final @NonNull Map<@NonNull Node, @NonNull AbstractReachabilityPartitionFactory> node2partitionFactory = new HashMap<Node, AbstractReachabilityPartitionFactory>();
    private final @NonNull Map<@NonNull Edge, @NonNull AbstractReachabilityPartitionFactory> edge2partitionFactory = new HashMap<Edge, AbstractReachabilityPartitionFactory>();
    private final @NonNull Iterable<@NonNull Node> thisAndTraceNodes;
    private final @NonNull SuccessNode globalSuccessNode;
    private @Nullable SuccessEdge localSuccessEdge = null;
    private @Nullable SuccessNode localSuccessNode = null;
    private @Nullable Edge dispatchSuccessEdge = null;
    private @NonNull List<@NonNull Node> thisAndTraceAndConstantSourceNodes = new ArrayList<Node>();
    private @Nullable AbstractReachabilityPartitionFactory currentPartitionFactory = null;

    public ReachabilityPartitioningStrategy(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull MappingPartitioner mappingPartitioner) {
        super(partitionedTransformationAnalysis, mappingPartitioner);
        assert (this.scheduleManager.useActivators());
        this.region = this.regionAnalysis.getRegion();
        this.originalNodes = Lists.newArrayList((Iterable)QVTscheduleUtil.getOwnedNodes((Region)this.region));
        this.originalEdges = Lists.newArrayList((Iterable)QVTscheduleUtil.getOwnedEdges((Region)this.region));
        SuccessNode globalSuccessNode = null;
        Node thisNode = null;
        Node traceNode = null;
        Node dispatchNode = null;
        for (Node node : this.originalNodes) {
            if (node.isThis()) {
                assert (thisNode == null) : "Only one this node permitted in " + this.region.getName();
                thisNode = node;
                this.thisAndTraceAndConstantSourceNodes.add(node);
                continue;
            }
            if (node.isTrace()) {
                assert (traceNode == null) : "Only one trace node permitted in " + this.region.getName();
                traceNode = node;
                this.thisAndTraceAndConstantSourceNodes.add(node);
                continue;
            }
            if (node.isDispatch()) {
                assert (dispatchNode == null) : "Only one dispatch node permitted in " + this.region.getName();
                dispatchNode = node;
                continue;
            }
            if (node.isSuccess()) {
                assert (globalSuccessNode == null) : "Only one success node permitted in " + this.region.getName();
                globalSuccessNode = (SuccessNode)node;
                continue;
            }
            if (!node.isConstant() || !Iterables.isEmpty((Iterable)node.getIncomingEdges())) continue;
            this.thisAndTraceAndConstantSourceNodes.add(node);
        }
        assert (globalSuccessNode != null) : "No global success node in " + this.region.getName();
        this.globalSuccessNode = globalSuccessNode;
        assert (traceNode != null) : "No trace node in " + this.region.getName();
        Iterable<Object> iterable = this.thisAndTraceNodes = thisNode != null ? Lists.newArrayList((Object[])new Node[]{thisNode, traceNode}) : Collections.singletonList(traceNode);
        if (dispatchNode != null) {
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges(dispatchNode)) {
                if (!edge.isSuccess() || !edge.isRealized()) continue;
                this.dispatchSuccessEdge = edge;
            }
        }
    }

    private void addEdge(@NonNull AbstractReachabilityPartitionFactory partitionFactory, @NonNull Edge edge) {
        if (!this.edge2partitionFactory.containsKey(edge)) {
            this.edge2partitionFactory.put(edge, partitionFactory);
        }
    }

    private void addNode(@NonNull AbstractReachabilityPartitionFactory partitionFactory, @NonNull Node node) {
        if (!this.node2partitionFactory.containsKey(node)) {
            this.node2partitionFactory.put(node, partitionFactory);
        }
    }

    private @Nullable CyclicRegionAnalysis basicGetCyclicRegionAnalysis() {
        return this.transformationAnalysis.basicGetCyclicRegionAnalysis(this.regionAnalysis);
    }

    protected @Nullable AbstractReachabilityPartitionFactory basicGetPartitionFactory(@NonNull Edge edge) {
        return this.edge2partitionFactory.get(edge);
    }

    protected @Nullable AbstractReachabilityPartitionFactory basicGetPartitionFactory(@NonNull Node node) {
        return this.node2partitionFactory.get(node);
    }

    @Override
    protected void check() {
        super.check();
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (!node.isPredicated() || this.node2partitionFactory.get(node) != null) continue;
            CompilerUtil.addRegionError(this.mappingPartitioner.getProblemHandler(), this.region, "Should have predicated " + node, new Object[0]);
        }
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
            if (!edge.isPredicated() || this.edge2partitionFactory.get(edge) != null) continue;
            CompilerUtil.addRegionError(this.mappingPartitioner.getProblemHandler(), this.region, "Should have predicated " + edge, new Object[0]);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createCtorPartitionFactory() {
        @NonNull Iterable headNodes = QVTscheduleUtil.getHeadNodes((Region)this.region);
        ArrayList<@NonNull Node> novelCtorNodes = new ArrayList<Node>();
        ArrayList<@NonNull NavigableEdge> novelCtorEdges = new ArrayList<NavigableEdge>();
        for (Node headNode : headNodes) {
            novelCtorNodes.add(headNode);
            for (Edge novelEdge : QVTscheduleUtil.getOutgoingEdges((Node)headNode)) {
                if (!(novelEdge instanceof NavigableEdge) || !novelEdge.isLoaded() || !Iterables.contains((Iterable)headNodes, (Object)QVTscheduleUtil.getTargetNode((Edge)novelEdge))) continue;
                novelCtorEdges.add((NavigableEdge)novelEdge);
            }
        }
        for (Node traceNode : this.thisAndTraceNodes) {
            if (novelCtorNodes.contains(traceNode)) continue;
            novelCtorNodes.add(traceNode);
            for (Edge novelEdge : QVTscheduleUtil.getOutgoingEdges((Node)traceNode)) {
                if (!(novelEdge instanceof NavigableEdge) || !Iterables.contains((Iterable)headNodes, (Object)QVTscheduleUtil.getTargetNode((Edge)novelEdge))) continue;
                novelCtorEdges.add((NavigableEdge)novelEdge);
            }
        }
        if (!novelCtorEdges.isEmpty() || novelCtorNodes.size() > 1) {
            ReachabilityForest ctorReachabilityForest = new ReachabilityForest("ctor", headNodes, novelCtorEdges);
            new CtorPartitionFactory(this, ctorReachabilityForest, headNodes, novelCtorNodes, novelCtorEdges);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Set<@NonNull Node> createInitPartitionFactory() {
        CyclicRegionAnalysis cyclicRegionAnalysis = this.basicGetCyclicRegionAnalysis();
        ArrayList<@NonNull Edge> reachingInitEdges = new ArrayList<Edge>();
        @NonNull UniqueList cyclicInitEdges = null;
        ArrayList<Edge> coCyclicInitEdges = null;
        UniqueList coCyclicInitNodes = null;
        for (Edge edge : this.originalEdges) {
            PropertyDatum propertyDatum;
            if (this.basicGetPartitionFactory(edge) != null) {
                reachingInitEdges.add(edge);
                continue;
            }
            if (!edge.isOld()) continue;
            boolean isCyclic = false;
            if (edge.isNavigable() && cyclicRegionAnalysis != null && cyclicRegionAnalysis.isCyclic(propertyDatum = this.scheduleManager.getPropertyDatum((NavigationEdge)edge))) {
                isCyclic = true;
                if (cyclicInitEdges == null) {
                    cyclicInitEdges = new UniqueList();
                }
                cyclicInitEdges.add((Object)edge);
                if (edge.isSuccess()) {
                    Node invokedNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                    for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)invokedNode)) {
                        List<Region> corollaryOf;
                        if (outgoingEdge == edge || !outgoingEdge.isPredicated() || !outgoingEdge.isNavigable() || (corollaryOf = this.transformationAnalysis.getCorollaryOf((NavigationEdge)outgoingEdge)) == null) continue;
                        if (coCyclicInitEdges == null) {
                            coCyclicInitEdges = new ArrayList<Edge>();
                        }
                        assert (!coCyclicInitEdges.contains(outgoingEdge));
                        coCyclicInitEdges.add(outgoingEdge);
                        Node corollaryNode = QVTscheduleUtil.getTargetNode((Edge)outgoingEdge);
                        if (coCyclicInitNodes == null) {
                            coCyclicInitNodes = new UniqueList();
                        }
                        assert (!coCyclicInitNodes.contains((Object)corollaryNode));
                        coCyclicInitNodes.add((Object)corollaryNode);
                    }
                }
            }
            if (isCyclic) continue;
            reachingInitEdges.add(edge);
        }
        if (coCyclicInitEdges != null) {
            reachingInitEdges.removeAll(coCyclicInitEdges);
        }
        UniqueList cyclicInitNodes = null;
        UniqueList reachingInitNodes = null;
        if (cyclicInitEdges != null) {
            reachingInitNodes = new UniqueList(this.thisAndTraceAndConstantSourceNodes);
            cyclicInitNodes = new UniqueList();
            int iMax = cyclicInitEdges.size();
            int i = 0;
            while (i < iMax) {
                Edge cyclicEdge = (Edge)cyclicInitEdges.get(i);
                this.pruneInitCyclicEdge((Set<Node>)cyclicInitNodes, (Set<Edge>)cyclicInitEdges, cyclicEdge);
                ++i;
            }
            reachingInitEdges.removeAll((Collection<?>)cyclicInitEdges);
            reachingInitNodes.removeAll((Collection)cyclicInitNodes);
        }
        ReachabilityForest initReachabilityForest1 = new ReachabilityForest("init", (Iterable<Node>)(reachingInitNodes != null ? reachingInitNodes : this.thisAndTraceAndConstantSourceNodes), reachingInitEdges);
        ArrayList<Object> novelInitNodes1 = null;
        for (Node node : initReachabilityForest1.getMostReachableFirstNodes()) {
            if (this.basicGetPartitionFactory(node) != null || Iterables.contains(this.thisAndTraceNodes, (Object)node) || coCyclicInitNodes != null && coCyclicInitNodes.contains((Object)node)) continue;
            if (novelInitNodes1 == null) {
                novelInitNodes1 = new ArrayList<Object>();
            }
            novelInitNodes1.add(node);
        }
        for (Node node : this.originalNodes) {
            if (this.basicGetPartitionFactory(node) != null || Iterables.contains(this.thisAndTraceNodes, (Object)node) || !node.isRealized() || !node.getClassDatum().getReferredTypedModel().isIsTrace()) continue;
            boolean hasSuccess = false;
            boolean hasPredicatedEdge = false;
            for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                if (outgoingEdge.isPredicated()) {
                    hasPredicatedEdge = true;
                }
                if (!outgoingEdge.isSuccess()) continue;
                hasSuccess = true;
            }
            if (!hasSuccess || !hasPredicatedEdge) continue;
            if (novelInitNodes1 == null) {
                novelInitNodes1 = new ArrayList();
            }
            novelInitNodes1.add(node);
        }
        if (novelInitNodes1 != null) {
            if (cyclicInitEdges == null) {
                for (Node node : this.originalNodes) {
                    ClassDatum classDatum;
                    if (!node.isRealized() || novelInitNodes1.contains(node) || this.basicGetPartitionFactory(node) != null || (classDatum = QVTscheduleUtil.getClassDatum((Node)node)).isCollectionType()) continue;
                    novelInitNodes1.add(node);
                }
            }
            if (!novelInitNodes1.contains(this.globalSuccessNode)) {
                novelInitNodes1.add(this.getLocalSuccessNode());
            }
            new InitPartitionFactory(this, initReachabilityForest1, this.thisAndTraceNodes, novelInitNodes1);
        }
        return coCyclicInitNodes;
    }

    private void pruneInitCyclicEdge(@NonNull Set<@NonNull Node> cyclicNodes, @NonNull Set<@NonNull Edge> cyclicEdges, @NonNull Edge cyclicEdge) {
        Node targetNode = QVTscheduleUtil.getTargetNode((Edge)cyclicEdge);
        this.pruneInitCyclicTargetNode(cyclicNodes, cyclicEdges, targetNode);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void pruneInitCyclicTargetNode(@NonNull Set<@NonNull Node> cyclicNodes, @NonNull Set<@NonNull Edge> cyclicEdges, @NonNull Node cyclicNode) {
        assert (!cyclicNodes.contains(cyclicNode));
        if (cyclicEdges.containsAll(cyclicNode.getIncomingEdges())) {
            cyclicNodes.add(cyclicNode);
            for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)cyclicNode)) {
                cyclicEdges.add(outgoingEdge);
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)outgoingEdge);
                if (cyclicNodes.contains(targetNode)) continue;
                this.pruneInitCyclicTargetNode(cyclicNodes, cyclicEdges, targetNode);
            }
        }
        if (cyclicNode.isExpression()) {
            boolean hasNavigation = false;
            @NonNull Iterable incomingEdges = QVTscheduleUtil.getIncomingEdges((Node)cyclicNode);
            for (Edge incomingEdge : incomingEdges) {
                if (!incomingEdge.isNavigation()) continue;
                hasNavigation = true;
                break;
            }
            if (!hasNavigation) {
                cyclicNodes.add(cyclicNode);
                for (Edge incomingEdge : incomingEdges) {
                    cyclicEdges.add(incomingEdge);
                    Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)incomingEdge);
                    if (cyclicNodes.contains(sourceNode)) continue;
                    this.pruneInitCyclicTargetNode(cyclicNodes, cyclicEdges, sourceNode);
                }
            }
        }
    }

    private void createLoopPartitionFactory() {
        ArrayList<@NonNull Object> reachingLoopEdges = new ArrayList<Object>();
        for (Edge edge : this.originalEdges) {
            if (this.basicGetPartitionFactory(edge) != null) {
                reachingLoopEdges.add(edge);
                continue;
            }
            if (!edge.isOld() || edge.isNavigable() && this.transformationAnalysis.isCorollary((NavigationEdge)edge)) continue;
            reachingLoopEdges.add(edge);
        }
        if (this.localSuccessEdge != null) {
            reachingLoopEdges.add(this.localSuccessEdge);
            if (this.dispatchSuccessEdge != null) {
                reachingLoopEdges.add(this.dispatchSuccessEdge);
            }
        }
        ReachabilityForest loopReachabilityForest = new ReachabilityForest("loop", this.thisAndTraceAndConstantSourceNodes, reachingLoopEdges);
        ArrayList<@NonNull Node> novelLoopNodes = null;
        for (Node node : loopReachabilityForest.getMostReachableFirstNodes()) {
            if (this.basicGetPartitionFactory(node) != null) continue;
            if (novelLoopNodes == null) {
                novelLoopNodes = new ArrayList<Node>();
            }
            novelLoopNodes.add(node);
        }
        if (novelLoopNodes != null) {
            if (this.localSuccessNode != null) {
                novelLoopNodes.add((Node)this.localSuccessNode);
            }
            for (Node node : this.originalNodes) {
                ClassDatum classDatum;
                if (node.isPredicated() || novelLoopNodes.contains(node) || this.basicGetPartitionFactory(node) != null || (classDatum = QVTscheduleUtil.getClassDatum((Node)node)).isCollectionType()) continue;
                novelLoopNodes.add(node);
            }
            ArrayList<@NonNull Edge> novelLoopEdges = new ArrayList<Edge>();
            for (Edge edge : this.originalEdges) {
                if (!edge.isRealized() || this.basicGetPartitionFactory(edge) != null) continue;
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                if (loopReachabilityForest.basicGetCost(sourceNode) == null && !Iterables.contains(novelLoopNodes, (Object)sourceNode) || loopReachabilityForest.basicGetCost(targetNode) == null && !Iterables.contains(novelLoopNodes, (Object)targetNode)) continue;
                novelLoopEdges.add(edge);
            }
            new LoopPartitionFactory(this, loopReachabilityForest, this.thisAndTraceNodes, novelLoopNodes, novelLoopEdges);
        }
    }

    protected void createNonPartition() {
        this.newPartitionAnalyses.add(new NonPartitionFactory(this.mappingPartitioner).createPartitionAnalysis(this.partitionedTransformationAnalysis));
    }

    private @Nullable Iterable<@NonNull Node> createRestPartitionFactory(@Nullable Set<@NonNull Node> coCyclicInitNodes) {
        ArrayList<@NonNull NavigationEdge> novelRestEdges = null;
        ArrayList<@NonNull Node> extraRestNodes = null;
        for (Edge edge : this.originalEdges) {
            if (!edge.isNavigable()) continue;
            NavigationEdge navigationEdge = (NavigationEdge)edge;
            if (!edge.isRealized() || this.basicGetPartitionFactory(edge) != null) continue;
            boolean assignIt = false;
            Node realizedTarget = QVTscheduleUtil.getTargetNode((Edge)navigationEdge);
            if (!realizedTarget.isPredicated() || this.basicGetPartitionFactory(realizedTarget) != null) {
                assignIt = true;
            } else if (coCyclicInitNodes != null && coCyclicInitNodes.contains(realizedTarget)) {
                assignIt = true;
            } else {
                if (extraRestNodes == null) {
                    extraRestNodes = new ArrayList<Node>();
                }
                extraRestNodes.add(realizedTarget);
            }
            if (!assignIt) continue;
            if (novelRestEdges == null) {
                novelRestEdges = new ArrayList<NavigationEdge>();
            }
            novelRestEdges.add(navigationEdge);
        }
        if (novelRestEdges != null) {
            ArrayList novelRestNodes;
            ArrayList<@NonNull Object> reachingRestEdges = new ArrayList<Object>();
            for (Edge edge : this.originalEdges) {
                if (!edge.isNavigable() || novelRestEdges.contains(edge)) continue;
                reachingRestEdges.add((NavigableEdge)edge);
            }
            SuccessEdge localSuccessEdge2 = this.localSuccessEdge;
            if (localSuccessEdge2 != null && this.basicGetPartitionFactory((Node)this.globalSuccessNode) == null) {
                reachingRestEdges.add(localSuccessEdge2);
                novelRestNodes = Lists.newArrayList((Object[])new Node[]{QVTscheduleUtil.getTargetNode((Edge)localSuccessEdge2), this.globalSuccessNode});
            } else {
                novelRestNodes = Collections.singletonList(this.globalSuccessNode);
            }
            ReachabilityForest restReachabilityForest = new ReachabilityForest("rest", this.thisAndTraceAndConstantSourceNodes, reachingRestEdges);
            new RestPartitionFactory(this, restReachabilityForest, this.thisAndTraceNodes, novelRestNodes, novelRestEdges);
        }
        return extraRestNodes;
    }

    private void createXtraPartitionFactory(@NonNull Iterable<@NonNull Node> xtraRestNodes) {
        ArrayList<@NonNull Edge> novelXtraEdges = new ArrayList<Edge>();
        ArrayList<@NonNull Edge> reachingXtraEdges = new ArrayList<Edge>();
        for (Edge edge : this.originalEdges) {
            if (this.basicGetPartitionFactory(edge) == null) {
                novelXtraEdges.add(edge);
                if (!edge.isOld()) continue;
                reachingXtraEdges.add(edge);
                continue;
            }
            reachingXtraEdges.add(edge);
        }
        ArrayList<@NonNull Object> novelXtraNodes = new ArrayList<Object>();
        novelXtraNodes.add(this.globalSuccessNode);
        for (Node node : this.originalNodes) {
            if (this.basicGetPartitionFactory(node) != null) continue;
            novelXtraNodes.add(node);
        }
        ReachabilityForest xtraReachabilityForest = new ReachabilityForest("xtra", this.thisAndTraceAndConstantSourceNodes, reachingXtraEdges);
        new XtraPartitionFactory(this, xtraReachabilityForest, this.thisAndTraceNodes, novelXtraNodes, novelXtraEdges);
    }

    private @NonNull SuccessNode getLocalSuccessNode() {
        SuccessNode localSuccessNode2 = this.localSuccessNode;
        if (localSuccessNode2 == null) {
            this.localSuccessEdge = this.regionAnalysis.createLocalSuccess();
            this.localSuccessNode = localSuccessNode2 = (SuccessNode)QVTscheduleUtil.getTargetNode((Edge)this.localSuccessEdge);
        }
        return localSuccessNode2;
    }

    private @NonNull AbstractReachabilityPartitionFactory getPartitionFactory(@NonNull Edge edge) {
        AbstractReachabilityPartitionFactory partitionFactory = this.edge2partitionFactory.get(edge);
        return (AbstractReachabilityPartitionFactory)ClassUtil.nonNullState((Object)partitionFactory);
    }

    private @NonNull AbstractReachabilityPartitionFactory getPartitionFactory(@NonNull Node node) {
        AbstractReachabilityPartitionFactory partitionFactory = this.node2partitionFactory.get(node);
        return (AbstractReachabilityPartitionFactory)ClassUtil.nonNullState((Object)partitionFactory);
    }

    public @NonNull Region getRegion() {
        return this.region;
    }

    public @NonNull AbstractTransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    @Override
    public @NonNull Iterable<@NonNull PartitionAnalysis> partition() {
        this.createCtorPartitionFactory();
        @Nullable Set<@NonNull Node> coCyclicInitNodes = this.createInitPartitionFactory();
        this.createLoopPartitionFactory();
        @Nullable Iterable<@NonNull Node> extraRestNodes = this.createRestPartitionFactory(coCyclicInitNodes);
        if (extraRestNodes != null) {
            this.createXtraPartitionFactory(extraRestNodes);
        }
        for (AbstractReachabilityPartitionFactory partitionFactory : this.partitionFactories) {
            this.newPartitionAnalyses.add(partitionFactory.createPartitionAnalysis(this.partitionedTransformationAnalysis));
        }
        this.check();
        return this.newPartitionAnalyses;
    }

    private void setCurrentPartitionFactory(@NonNull AbstractReachabilityPartitionFactory currentPartitionFactory) {
        if (this.currentPartitionFactory != null) {
            currentPartitionFactory.addPredecessor(this.currentPartitionFactory);
        }
        this.currentPartitionFactory = currentPartitionFactory;
        this.partitionFactories.add(currentPartitionFactory);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.mappingPartitioner.getName());
        for (AbstractReachabilityPartitionFactory partitionFactory : this.partitionFactories) {
            s.append("\n\t");
            partitionFactory.toString(s, "\n\t");
        }
        return s.toString();
    }

    @Override
    protected boolean useActivators() {
        return true;
    }

    protected static abstract class AbstractReachabilityPartitionFactory
    extends AbstractSimplePartitionFactory {
        protected final @NonNull ReachabilityPartitioningStrategy strategy;
        protected final @NonNull String name;
        protected final @NonNull ReachabilityForest reachabilityForest;
        protected final @NonNull Iterable<@NonNull ? extends Node> headNodes;
        protected final @Nullable Iterable<@NonNull ? extends Node> novelNodes;
        protected final @Nullable Iterable<@NonNull ? extends Edge> novelEdges;
        private final @NonNull UniqueList<@NonNull AbstractReachabilityPartitionFactory> predecessors = new UniqueList();
        private final @NonNull List<@NonNull Node> reachableNodes = new ArrayList<Node>();
        private final @NonNull List<@NonNull Edge> reachableEdges = new ArrayList<Edge>();

        protected AbstractReachabilityPartitionFactory(@NonNull ReachabilityPartitioningStrategy strategy, @NonNull ReachabilityForest reachabilityForest, @NonNull Iterable<@NonNull ? extends Node> headNodes, @Nullable Iterable<@NonNull ? extends Node> novelNodes, @Nullable Iterable<@NonNull ? extends Edge> novelEdges) {
            super(strategy.mappingPartitioner);
            this.strategy = strategy;
            strategy.setCurrentPartitionFactory(this);
            this.name = this.computeName((String)ClassUtil.nonNullState((Object)reachabilityForest.getDisambiguator()));
            this.reachabilityForest = reachabilityForest;
            this.headNodes = headNodes;
            this.novelNodes = novelNodes;
            this.novelEdges = novelEdges;
            if (novelNodes != null) {
                for (Node node : novelNodes) {
                    this.addReachableNode(node);
                }
            }
            if (novelEdges != null) {
                for (Edge edge : novelEdges) {
                    this.addReachableEdge(edge);
                }
            }
        }

        public void addPredecessor(@NonNull AbstractReachabilityPartitionFactory predecessor) {
            this.predecessors.add((Object)predecessor);
        }

        private boolean addReachableEdge(@NonNull Edge edge) {
            if (this.reachableEdges.contains(edge)) {
                return false;
            }
            this.addReachableNode(QVTscheduleUtil.getSourceNode((Edge)edge));
            this.addReachableNode(QVTscheduleUtil.getTargetNode((Edge)edge));
            this.reachableEdges.add(edge);
            this.strategy.addEdge(this, edge);
            return true;
        }

        private void addReachableEdgeAndOpposite(@NonNull Edge reachingEdge) {
            NavigationEdge oppositeEdge;
            this.addReachableEdge(reachingEdge);
            if (reachingEdge.isNavigable() && (oppositeEdge = ((NavigationEdge)reachingEdge).getOppositeEdge()) != null) {
                this.addReachableEdge((Edge)oppositeEdge);
            }
        }

        private boolean addReachableNode(@NonNull Node node) {
            if (this.reachableNodes.contains(node)) {
                return false;
            }
            this.reachableNodes.add(node);
            this.strategy.addNode(this, node);
            for (Node predecessor : this.reachabilityForest.getPredecessorsClosure(node)) {
                this.addReachableNode(predecessor);
            }
            return true;
        }

        @Override
        public @NonNull PartitionAnalysis createPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
            Role role;
            BasicPartition partition = this.createBasicPartition(this.name, this.headNodes);
            for (Node node : this.reachableNodes) {
                role = this.resolveNodeRole(node);
                this.addNode(partition, node, role);
            }
            for (Edge edge : this.reachableEdges) {
                if (edge.isSecondary()) continue;
                role = this.resolveEdgeRole(edge);
                this.addEdge(partition, edge, role);
            }
            BasicPartitionAnalysis basicPartitionAnalysis = new BasicPartitionAnalysis(partitionedTransformationAnalysis, partition, this.reachabilityForest, "xyzzy", "xyzzy");
            if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
                this.scheduleManager.writeDebugGraphs((Graphable)partition, null);
            }
            return basicPartitionAnalysis;
        }

        protected void initPartitionFactory() {
            int i = 0;
            while (i < this.reachableNodes.size()) {
                @NonNull Node sourceNode = this.reachableNodes.get(i);
                for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
                    Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                    AbstractReachabilityPartitionFactory targetPartitionFactory = this.strategy.basicGetPartitionFactory(targetNode);
                    if (targetPartitionFactory != null || !edge.isLoaded()) continue;
                    this.addReachableNode(targetNode);
                }
                ++i;
            }
            for (Node targetNode : this.reachableNodes) {
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                    Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                    AbstractReachabilityPartitionFactory sourcePartitionFactory = this.strategy.basicGetPartitionFactory(sourceNode);
                    if (sourcePartitionFactory == null || !this.reachableNodes.contains(sourceNode)) continue;
                    this.addReachableEdge(edge);
                    if (sourcePartitionFactory == this) continue;
                    this.addPredecessor(sourcePartitionFactory);
                }
            }
        }

        protected void initPartitionFactoryAsJustReachables() {
            int i = 0;
            while (i < this.reachableNodes.size()) {
                Node node = this.reachableNodes.get(i);
                for (Edge reachingEdge : this.reachabilityForest.getReachingEdges(node)) {
                    this.addReachableEdgeAndOpposite(reachingEdge);
                }
                ++i;
            }
            i = 0;
            while (i < this.reachableEdges.size()) {
                Edge edge = this.reachableEdges.get(i);
                for (Edge reachingEdge : this.reachabilityForest.getReachingEdges(QVTscheduleUtil.getSourceNode((Edge)edge))) {
                    this.addReachableEdgeAndOpposite(reachingEdge);
                }
                for (Edge reachingEdge : this.reachabilityForest.getReachingEdges(QVTscheduleUtil.getTargetNode((Edge)edge))) {
                    this.addReachableEdgeAndOpposite(reachingEdge);
                }
                ++i;
            }
        }

        protected @NonNull Role resolveEdgeRole(@NonNull Edge edge) {
            Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
            if (edgeRole == Role.REALIZED && this.strategy.getPartitionFactory(edge) != this) {
                return Role.PREDICATED;
            }
            return edgeRole;
        }

        @Override
        protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
            if (this.mappingPartitioner.hasRealizedEdge(edge)) {
                return Role.PREDICATED;
            }
            Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
            return edgeRole;
        }

        protected @NonNull Role resolveNodeRole(@NonNull Node node) {
            Role nodeRole = QVTscheduleUtil.getNodeRole((Node)node);
            if (nodeRole == Role.REALIZED && this.strategy.getPartitionFactory(node) != this) {
                return Role.PREDICATED;
            }
            return nodeRole;
        }

        @Override
        public @NonNull String toString() {
            return this.toString(new StringBuilder(), "\n");
        }

        public @NonNull String toString(@NonNull StringBuilder s, @NonNull String prefix) {
            Iterable<? extends Edge> novelEdges2;
            s.append(this.name);
            s.append(String.valueOf(prefix) + "\tpredecessors: ");
            for (AbstractReachabilityPartitionFactory predecessor : this.predecessors) {
                s.append(" " + predecessor.name);
            }
            Iterable<@NonNull ? extends Node> novelNodes2 = this.novelNodes;
            if (novelNodes2 != null) {
                s.append(String.valueOf(prefix) + "\tnovel nodes");
                for (Node node : novelNodes2) {
                    s.append(String.valueOf(prefix) + "\t\t" + node);
                }
            }
            if ((novelEdges2 = this.novelEdges) != null) {
                s.append(String.valueOf(prefix) + "\tnovel edges");
                for (Edge edge : novelEdges2) {
                    s.append(String.valueOf(prefix) + "\t\t" + edge);
                }
            }
            s.append(String.valueOf(prefix) + "\treachable nodes");
            for (Node node : this.reachableNodes) {
                s.append(String.valueOf(prefix) + "\t\t" + node);
            }
            s.append(String.valueOf(prefix) + "\treachable edges");
            for (Edge edge : this.reachableEdges) {
                s.append(String.valueOf(prefix) + "\t\t" + edge);
            }
            return s.toString();
        }
    }

    protected static class CtorPartitionFactory
    extends AbstractReachabilityPartitionFactory {
        protected CtorPartitionFactory(@NonNull ReachabilityPartitioningStrategy strategy, @NonNull ReachabilityForest reachabilityForest, @NonNull Iterable<@NonNull ? extends Node> headNodes, @NonNull Iterable<@NonNull ? extends Node> novelNodes, @NonNull Iterable<@NonNull ? extends Edge> novelEdges) {
            super(strategy, reachabilityForest, headNodes, novelNodes, novelEdges);
        }

        @Override
        protected void initPartitionFactory() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected @NonNull Role resolveNodeRole(@NonNull Node node) {
            Role nodeRole = node.getNodeRole();
            if (nodeRole == Role.REALIZED) {
                return Role.SPECULATION;
            }
            return super.resolveNodeRole(node);
        }
    }

    protected static class InitPartitionFactory
    extends AbstractReachabilityPartitionFactory {
        protected InitPartitionFactory(@NonNull ReachabilityPartitioningStrategy strategy, @NonNull ReachabilityForest reachabilityForest, @NonNull Iterable<@NonNull ? extends Node> headNodes, @NonNull Iterable<@NonNull ? extends Node> novelNodes) {
            super(strategy, reachabilityForest, headNodes, novelNodes, null);
            this.initPartitionFactory();
        }

        @Override
        protected @NonNull Role resolveNodeRole(@NonNull Node node) {
            if (node.isTrace()) {
                return Role.SPECULATED;
            }
            return super.resolveNodeRole(node);
        }
    }

    protected static class LoopPartitionFactory
    extends AbstractReachabilityPartitionFactory {
        protected LoopPartitionFactory(@NonNull ReachabilityPartitioningStrategy strategy, @NonNull ReachabilityForest reachabilityForest, @NonNull Iterable<@NonNull ? extends Node> headNodes, @NonNull Iterable<@NonNull ? extends Node> novelNodes, @NonNull Iterable<@NonNull ? extends Edge> novelEdges) {
            super(strategy, reachabilityForest, headNodes, novelNodes, novelEdges);
            this.initPartitionFactory();
        }

        @Override
        protected @NonNull Role resolveEdgeRole(@NonNull Edge edge) {
            CyclicRegionAnalysis cyclicRegionAnalysis = this.strategy.basicGetCyclicRegionAnalysis();
            if (cyclicRegionAnalysis != null && edge.getEdgeRole() == Role.PREDICATED && edge instanceof SuccessEdge) {
                Node targetNode;
                assert (!edge.isSecondary());
                SuccessEdge navigationEdge = (SuccessEdge)edge;
                PropertyDatum propertyDatum = this.strategy.scheduleManager.getPropertyDatum((NavigationEdge)navigationEdge);
                if (cyclicRegionAnalysis.isCyclic(propertyDatum) && (targetNode = QVTscheduleUtil.getTargetNode((Edge)navigationEdge)) instanceof BooleanLiteralNode && ((BooleanLiteralNode)targetNode).isBooleanValue()) {
                    return Role.SPECULATED;
                }
            }
            return super.resolveEdgeRole(edge);
        }

        @Override
        protected @NonNull Role resolveNodeRole(@NonNull Node node) {
            if (node.isTrace()) {
                return Role.SPECULATED;
            }
            if (node == this.strategy.localSuccessNode) {
                return Role.CONSTANT_SUCCESS_TRUE;
            }
            return super.resolveNodeRole(node);
        }
    }

    protected static class RestPartitionFactory
    extends AbstractReachabilityPartitionFactory {
        protected RestPartitionFactory(@NonNull ReachabilityPartitioningStrategy strategy, @NonNull ReachabilityForest reachabilityForest, @NonNull Iterable<@NonNull ? extends Node> headNodes, @NonNull Iterable<@NonNull ? extends Node> novelNodes, @NonNull Iterable<@NonNull ? extends Edge> novelEdges) {
            super(strategy, reachabilityForest, headNodes, novelNodes, novelEdges);
            this.initPartitionFactory();
        }

        @Override
        protected void initPartitionFactory() {
            this.initPartitionFactoryAsJustReachables();
        }

        @Override
        protected @NonNull Role resolveNodeRole(@NonNull Node node) {
            if (node instanceof SuccessNode) {
                return Role.CONSTANT_SUCCESS_TRUE;
            }
            return super.resolveNodeRole(node);
        }
    }

    protected static class XtraPartitionFactory
    extends AbstractReachabilityPartitionFactory {
        protected XtraPartitionFactory(@NonNull ReachabilityPartitioningStrategy strategy, @NonNull ReachabilityForest reachabilityForest, @NonNull Iterable<@NonNull ? extends Node> headNodes, @NonNull Iterable<@NonNull ? extends Node> novelNodes, @NonNull Iterable<@NonNull ? extends Edge> novelEdges) {
            super(strategy, reachabilityForest, headNodes, novelNodes, novelEdges);
            this.initPartitionFactory();
        }

        @Override
        protected void initPartitionFactory() {
            this.initPartitionFactoryAsJustReachables();
        }

        @Override
        protected @NonNull Role resolveNodeRole(@NonNull Node node) {
            if (node instanceof SuccessNode) {
                return Role.CONSTANT_SUCCESS_TRUE;
            }
            return super.resolveNodeRole(node);
        }
    }
}

