/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.css;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.wildwebdeveloper.css.ui.preferences.CSSPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.css.ui.preferences.less.LESSPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.css.ui.preferences.scss.SCSSPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.ui.preferences.Settings;

public class CSSLanguageClient
extends LanguageClientImpl {
    public CompletableFuture<List<Object>> configuration(ConfigurationParams params) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Object> settings = new ArrayList<Object>();
            for (ConfigurationItem item : params.getItems()) {
                Settings cssSettings;
                String section = item.getSection();
                if (CSSPreferenceServerConstants.isMatchCssSection(section)) {
                    cssSettings = CSSPreferenceServerConstants.getGlobalSettings();
                    settings.add(cssSettings.findSettings(section.split("[.]")));
                    continue;
                }
                if (LESSPreferenceServerConstants.isMatchLessSection(section)) {
                    cssSettings = LESSPreferenceServerConstants.getGlobalSettings();
                    settings.add(cssSettings.findSettings(section.split("[.]")));
                    continue;
                }
                if (SCSSPreferenceServerConstants.isMatchScssSection(section)) {
                    cssSettings = SCSSPreferenceServerConstants.getGlobalSettings();
                    settings.add(cssSettings.findSettings(section.split("[.]")));
                    continue;
                }
                settings.add(null);
            }
            return settings;
        });
    }
}

