/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.efs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ChromiumScriptStorage {
    private static final IPath ROOT_PATH = new Path(null, "");
    private static final ChromiumScriptStorage INSTANCE = new ChromiumScriptStorage();
    private static final String[] EMPTY_NAMES = new String[0];
    private final RootNode ROOT = new RootNode();

    public static ChromiumScriptStorage getInstance() {
        return INSTANCE;
    }

    private CommonNode find(IPath path) {
        if (path == null) {
            return null;
        }
        CommonNode currentNode = this.ROOT;
        int i = 0;
        int length = path.segmentCount();
        while (i < length) {
            if (currentNode == null || currentNode.isFile()) {
                return null;
            }
            currentNode = (CommonNode)((FolderNode)currentNode).children.get(path.segment(i));
            ++i;
        }
        return currentNode;
    }

    String[] childNames(IPath path) {
        Map<String, CommonNode> childrenMap = this.childNodes(path);
        if (childrenMap == null) {
            return EMPTY_NAMES;
        }
        return childrenMap.keySet().toArray(EMPTY_NAMES);
    }

    OutputStream openOutputStream(IPath path, int options) throws CoreException {
        CommonNode node = this.find(path);
        if (node == null) {
            if (path.segmentCount() > 0) {
                CommonNode parent = this.find(ChromiumScriptStorage.getParentPath(path));
                if (parent != null && !parent.isFile()) {
                    FileNode fileNode = ChromiumScriptStorage.createFile(path, parent);
                    return fileNode.getOutputStream(options);
                }
                throw ChromiumScriptStorage.newCoreException("Bad store path (no parent folder), child=" + path, null);
            }
            throw ChromiumScriptStorage.newCoreException("Cannot open OutputStream for the Root", null);
        }
        if (node.isFile()) {
            return ((FileNode)node).getOutputStream(options);
        }
        throw ChromiumScriptStorage.newCoreException("Cannot open a directory for writing: " + path, null);
    }

    void mkdir(IPath path, int options) throws CoreException {
        CommonNode node = this.find(path);
        if (node != null || path.segmentCount() == 0) {
            return;
        }
        IPath parentPath = ChromiumScriptStorage.getParentPath(path);
        CommonNode parentNode = this.find(parentPath);
        if ((options & 4) != 0) {
            IPath chainPath = ROOT_PATH;
            CommonNode childNode = null;
            parentNode = this.find(ROOT_PATH);
            int i = 0;
            int length = path.segmentCount();
            while (i < length) {
                childNode = this.find(chainPath = chainPath.append(path.segment(i)));
                if (childNode == null) {
                    ChromiumScriptStorage.createFolder(chainPath, parentNode);
                    parentNode = childNode;
                } else if (childNode.isFile()) {
                    throw ChromiumScriptStorage.newCoreException("File encountered in the path: " + chainPath, null);
                }
                ++i;
            }
        } else {
            if (parentNode == null) {
                throw ChromiumScriptStorage.newCoreException("Parent does not exist, child=" + path, null);
            }
            if (!parentNode.isFile()) {
                ChromiumScriptStorage.createFolder(path, parentNode);
            } else {
                throw ChromiumScriptStorage.newCoreException("Parent is a file: " + parentNode.path, null);
            }
        }
    }

    void delete(IPath path, int options) throws CoreException {
        CommonNode parent = this.find(ChromiumScriptStorage.getParentPath(path));
        if (parent == null) {
            return;
        }
        if (parent.isFile()) {
            throw ChromiumScriptStorage.newCoreException("Parent is not a directory: " + ChromiumScriptStorage.getParentPath(path), null);
        }
        FolderNode parentFolder = (FolderNode)parent;
        parentFolder.remove(path.lastSegment());
    }

    InputStream openInputStream(IPath path, int options) throws CoreException {
        CommonNode node = this.find(path);
        if (node == null) {
            throw ChromiumScriptStorage.newCoreException("File not found: " + path, null);
        }
        if (!node.isFile()) {
            throw ChromiumScriptStorage.newCoreException("Cannot open InputStream on directory: " + path, null);
        }
        return ((FileNode)node).getInputStream();
    }

    IFileInfo fetchInfo(IPath path, int options) {
        CommonNode node = this.find(path);
        if (node == null) {
            FileInfo fileInfo = new FileInfo(path.lastSegment());
            fileInfo.setExists(false);
            return fileInfo;
        }
        return node.info;
    }

    void putInfo(IPath path, IFileInfo info, int options) throws CoreException {
        CommonNode node = this.find(path);
        if (node == null) {
            throw ChromiumScriptStorage.newCoreException("The store does not exist: " + path, null);
        }
        if ((options & 0x400) != 0) {
            ChromiumScriptStorage.copyAttribute(info, (IFileInfo)node.info, 8);
            ChromiumScriptStorage.copyAttribute(info, (IFileInfo)node.info, 4);
            ChromiumScriptStorage.copyAttribute(info, (IFileInfo)node.info, 16);
            ChromiumScriptStorage.copyAttribute(info, (IFileInfo)node.info, 64);
            ChromiumScriptStorage.copyAttribute(info, (IFileInfo)node.info, 2);
        }
        if ((options & 0x800) != 0) {
            node.info.setLastModified(info.getLastModified());
        }
    }

    private static void copyAttribute(IFileInfo from, IFileInfo to, int attribute) {
        to.setAttribute(attribute, from.getAttribute(attribute));
    }

    private static CoreException newCoreException(String message, Throwable cause) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", message, cause));
    }

    private static IPath getParentPath(IPath path) {
        if (path.segmentCount() == 0) {
            return null;
        }
        return path.removeLastSegments(1);
    }

    private static void createFolder(IPath path, CommonNode parentNode) {
        new FolderNode(path, (FolderNode)parentNode);
    }

    private static FileNode createFile(IPath path, CommonNode parent) {
        return new FileNode(path, (FolderNode)parent);
    }

    private Map<String, CommonNode> childNodes(IPath parent) {
        CommonNode node = this.find(parent);
        if (node == null || node.isFile()) {
            return null;
        }
        return ((FolderNode)node).children;
    }

    private static abstract class CommonNode {
        final IPath path;
        final FileInfo info;
        final CommonNode parent;

        CommonNode(IPath path, FolderNode parent, boolean isDirectory) {
            this.path = path;
            this.parent = parent;
            this.info = new FileInfo(path.lastSegment());
            this.info.setDirectory(isDirectory);
            this.info.setExists(true);
            if (parent != null) {
                parent.add(this);
            }
        }

        String getName() {
            return this.info.getName();
        }

        boolean isFile() {
            return !this.info.isDirectory();
        }
    }

    private static class FileNode
    extends CommonNode {
        private static final byte[] EMPTY_BYTES = new byte[0];
        protected volatile byte[] contents = EMPTY_BYTES;

        FileNode(IPath path, FolderNode parent) {
            super(path, parent, false);
        }

        synchronized InputStream getInputStream() {
            return new ByteArrayInputStream(this.contents);
        }

        synchronized OutputStream getOutputStream(final int options) {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    byte[] data;
                    super.close();
                    if ((options & 1) == 0) {
                        data = this.toByteArray();
                    } else {
                        byte[] outputData = this.toByteArray();
                        data = new byte[contents.length + this.size()];
                        System.arraycopy(contents, 0, data, 0, contents.length);
                        System.arraycopy(outputData, 0, data, contents.length, outputData.length);
                    }
                    this.setFileContents(data);
                }
            };
        }

        protected synchronized void setFileContents(byte[] data) {
            this.contents = data;
            this.info.setLength((long)data.length);
            this.info.setLastModified(System.currentTimeMillis());
            this.info.setExists(true);
        }
    }

    private static class FolderNode
    extends CommonNode {
        private final Map<String, CommonNode> children = Collections.synchronizedMap(new HashMap());

        FolderNode(IPath path, FolderNode parent) {
            super(path, parent, true);
        }

        void add(CommonNode node) {
            this.children.put(node.getName(), node);
        }

        void remove(String name) {
            CommonNode removedNode = this.children.remove(name);
            if (removedNode != null) {
                removedNode.info.setExists(false);
            }
        }
    }

    private static class RootNode
    extends FolderNode {
        RootNode() {
            super(ROOT_PATH, null);
            if (this.parent != null) {
                throw new IllegalArgumentException("Parent must be null, was: " + this.parent);
            }
        }

        @Override
        synchronized void add(CommonNode node) {
            if (node.isFile()) {
                throw new IllegalArgumentException("Cannot add files to the root");
            }
            super.add(node);
        }
    }
}

