/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.DebugEventListener;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.JavascriptVmFactory;
import org.eclipse.wst.jsdt.chromium.StandaloneVm;
import org.eclipse.wst.jsdt.chromium.TabDebugEventListener;
import org.eclipse.wst.jsdt.chromium.UnsupportedVersionException;
import org.eclipse.wst.jsdt.chromium.debug.core.ScriptNameManipulator;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptVmEmbedder;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.model.NamedConnectionLoggerFactory;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WipTabSelector;
import org.eclipse.wst.jsdt.chromium.debug.core.util.JavaScriptRegExpSupport;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;
import org.eclipse.wst.jsdt.chromium.wip.WipBackend;
import org.eclipse.wst.jsdt.chromium.wip.WipBrowser;
import org.eclipse.wst.jsdt.chromium.wip.WipBrowserFactory;
import org.eclipse.wst.jsdt.chromium.wip.WipBrowserTab;

public class JavascriptVmEmbedderFactory {
    private static final ScriptNameManipulator STANDALONE_SCRIPT_NAME_MANIPULATOR = new ScriptNameManipulator(){

        @Override
        public ScriptNameManipulator.FilePath getFileName(String scriptName) {
            return new StringBasedFileName(scriptName);
        }

        @Override
        public ScriptNameManipulator.ScriptNamePattern createPattern(List<String> components) {
            String pathString = BasicUtil.join(components, (String)"/");
            return new ScriptNameManipulator.ScriptNamePattern(String.valueOf(JavaScriptRegExpSupport.encodeLiteral(pathString)) + "/?$");
        }
    };

    public static JavascriptVmEmbedder.ConnectionToRemote connectToWipBrowser(String host, int port, WipBackend backend, final NamedConnectionLoggerFactory browserLoggerFactory, NamedConnectionLoggerFactory tabLoggerFactory, WipTabSelector tabSelector) throws CoreException {
        InetSocketAddress address = new InetSocketAddress(host, port);
        WipBrowserFactory.LoggerFactory factory = new WipBrowserFactory.LoggerFactory(){

            public ConnectionLogger newBrowserConnectionLogger() {
                return browserLoggerFactory.createLogger("Connection to browser");
            }

            public ConnectionLogger newTabConnectionLogger() {
                return browserLoggerFactory.createLogger("Connection to tab");
            }
        };
        WipBrowser browser = WipBrowserFactory.INSTANCE.createBrowser(address, factory);
        return JavascriptVmEmbedderFactory.connectWip(browser, backend, tabSelector);
    }

    private static JavascriptVmEmbedder.ConnectionToRemote connectWip(final WipBrowser browser, final WipBackend backend, final WipTabSelector tabSelector) throws CoreException {
        return new JavascriptVmEmbedder.ConnectionToRemote(){

            @Override
            public JavascriptVmEmbedder.VmConnector selectVm() throws CoreException {
                WipBrowser.WipTabConnector targetTabConnector;
                WipTabSelector.BrowserAndBackend browserAndBackend = new WipTabSelector.BrowserAndBackend(){

                    @Override
                    public WipBrowser getBrowser() {
                        return browser;
                    }

                    @Override
                    public WipBackend getBackend() {
                        return backend;
                    }
                };
                try {
                    targetTabConnector = tabSelector.selectTab(browserAndBackend);
                }
                catch (IOException e) {
                    throw JavascriptVmEmbedderFactory.newCoreException("Failed to get tabs for debugging", e);
                }
                if (targetTabConnector == null) {
                    return null;
                }
                return new WipEmbeddingTabConnector(targetTabConnector, backend.getId());
            }

            @Override
            public void disposeConnection() {
            }
        };
    }

    public static JavascriptVmEmbedder.ConnectionToRemote connectToStandalone(String host, int port, NamedConnectionLoggerFactory connectionLoggerFactory) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        ConnectionLogger connectionLogger = connectionLoggerFactory.createLogger(((Object)address).toString());
        final StandaloneVm standaloneVm = JavascriptVmFactory.getInstance().createStandalone((SocketAddress)address, connectionLogger);
        return new JavascriptVmEmbedder.ConnectionToRemote(){

            @Override
            public JavascriptVmEmbedder.VmConnector selectVm() {
                return new JavascriptVmEmbedder.VmConnector(){

                    @Override
                    public JavascriptVmEmbedder attach(JavascriptVmEmbedder.Listener embedderListener, DebugEventListener debugEventListener) throws CoreException {
                        embedderListener = null;
                        try {
                            standaloneVm.attach(debugEventListener);
                        }
                        catch (IOException e) {
                            throw JavascriptVmEmbedderFactory.newCoreException("Failed to connect to Standalone V8 VM", e);
                        }
                        catch (UnsupportedVersionException e) {
                            throw JavascriptVmEmbedderFactory.newCoreException("Failed to connect to Standalone V8 VM", e);
                        }
                        return new JavascriptVmEmbedder(){

                            @Override
                            public JavascriptVm getJavascriptVm() {
                                return standaloneVm;
                            }

                            @Override
                            public String getTargetName() {
                                String embedderName = standaloneVm.getEmbedderName();
                                String vmVersion = standaloneVm.getVmVersion();
                                String disconnectReason = standaloneVm.getDisconnectReason();
                                String targetTitle = embedderName == null ? "" : MessageFormat.format(Messages.JavascriptVmEmbedderFactory_TargetName0, embedderName, vmVersion);
                                boolean isAttached = standaloneVm.isAttached();
                                if (!isAttached) {
                                    String disconnectMessage = disconnectReason == null ? Messages.JavascriptVmEmbedderFactory_Terminated : MessageFormat.format(Messages.JavascriptVmEmbedderFactory_TerminatedWithReason, disconnectReason);
                                    targetTitle = "<" + disconnectMessage + "> " + targetTitle;
                                }
                                return targetTitle;
                            }

                            @Override
                            public String getThreadName() {
                                return "";
                            }

                            @Override
                            public ScriptNameManipulator getScriptNameManipulator() {
                                return STANDALONE_SCRIPT_NAME_MANIPULATOR;
                            }
                        };
                    }
                };
            }

            @Override
            public void disposeConnection() {
            }
        };
    }

    private static CoreException newCoreException(String message, Throwable cause) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", message, cause));
    }

    private static CoreException newCoreException(Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", "Failed to connect to the remote browser", (Throwable)e));
    }

    private static abstract class EmbeddingTabConnectorBase<TC>
    implements JavascriptVmEmbedder.VmConnector {
        private final TC targetTabConnector;
        private static final ScriptNameManipulator BROWSER_SCRIPT_NAME_MANIPULATOR = new ScriptNameManipulator(){

            @Override
            public ScriptNameManipulator.FilePath getFileName(String scriptName) {
                String filePath;
                try {
                    URI uri = new URI(scriptName);
                    filePath = uri.getPath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    filePath = scriptName;
                }
                return new StringBasedFileName(filePath);
            }

            @Override
            public ScriptNameManipulator.ScriptNamePattern createPattern(List<String> components) {
                String pathString = BasicUtil.join(components, (String)"/");
                return new ScriptNameManipulator.ScriptNamePattern(String.valueOf(JavaScriptRegExpSupport.encodeLiteral(pathString)) + "/?($|\\?)");
            }
        };

        EmbeddingTabConnectorBase(TC targetTabConnector) {
            this.targetTabConnector = targetTabConnector;
        }

        protected TC getTabConnector() {
            return this.targetTabConnector;
        }

        @Override
        public JavascriptVmEmbedder attach(final JavascriptVmEmbedder.Listener embedderListener, final DebugEventListener debugEventListener) throws CoreException {
            TabDebugEventListener tabDebugEventListener = new TabDebugEventListener(){

                public DebugEventListener getDebugEventListener() {
                    return debugEventListener;
                }

                public void closed() {
                    embedderListener.closed();
                }

                public void navigated(String newUrl) {
                    embedderListener.reset();
                }
            };
            return this.attach(tabDebugEventListener);
        }

        protected abstract JavascriptVmEmbedder attach(TabDebugEventListener var1) throws CoreException;

        protected static abstract class EmbedderBase
        implements JavascriptVmEmbedder {
            protected EmbedderBase() {
            }

            @Override
            public ScriptNameManipulator getScriptNameManipulator() {
                return BROWSER_SCRIPT_NAME_MANIPULATOR;
            }
        }
    }

    private static class StringBasedFileName
    implements ScriptNameManipulator.FilePath {
        private final String fullName;
        private final int lastPos;

        public StringBasedFileName(String fullName) {
            this.fullName = fullName;
            this.lastPos = fullName.lastIndexOf(47);
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private int currentPos;
                {
                    this.currentPos = stringBasedFileName.lastPos;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String next() {
                    int nextPos = fullName.lastIndexOf(47, this.currentPos - 1);
                    String result = nextPos == -1 ? fullName.substring(0, this.currentPos) : fullName.substring(nextPos + 1, this.currentPos);
                    this.currentPos = nextPos;
                    return result;
                }

                @Override
                public boolean hasNext() {
                    return this.currentPos != -1;
                }
            };
        }

        @Override
        public String getLastComponent() {
            if (this.lastPos == -1) {
                return this.fullName;
            }
            return this.fullName.substring(this.lastPos + 1);
        }
    }

    private static class WipEmbeddingTabConnector
    extends EmbeddingTabConnectorBase<WipBrowser.WipTabConnector> {
        private final String backendId;

        WipEmbeddingTabConnector(WipBrowser.WipTabConnector targetTabConnector, String backendId) {
            super(targetTabConnector);
            this.backendId = backendId;
        }

        @Override
        protected JavascriptVmEmbedder attach(TabDebugEventListener tabDebugEventListener) throws CoreException {
            WipBrowserTab browserTab;
            try {
                browserTab = ((WipBrowser.WipTabConnector)this.getTabConnector()).attach(tabDebugEventListener);
            }
            catch (IOException e) {
                throw JavascriptVmEmbedderFactory.newCoreException("Failed to connect to browser tab: " + e.getMessage(), e);
            }
            return new EmbeddingTabConnectorBase.EmbedderBase(){

                @Override
                public JavascriptVm getJavascriptVm() {
                    return browserTab.getJavascriptVm();
                }

                @Override
                public String getTargetName() {
                    return String.valueOf(Messages.DebugTargetImpl_TargetName) + " # " + backendId;
                }

                @Override
                public String getThreadName() {
                    return browserTab.getUrl();
                }
            };
        }
    }
}

