/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.viewsupport.WorkingSetFilter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;

public abstract class WorkingSetFilterUI {
    private IPropertyChangeListener fWorkingSetListener;
    private IWorkingSet fWorkingSet;
    WorkingSetFilterActionGroup fWorkingSetFilterGroup;
    private IViewPart fViewPart;
    private WorkingSetFilter fWorkingSetFilter = null;
    private IWorkingSetManager fWSManager = PlatformUI.getWorkbench().getWorkingSetManager();

    public WorkingSetFilterUI(IViewPart viewPart, IMemento memento, String key) {
        IWorkingSet ws;
        this.fViewPart = viewPart;
        if (memento != null && (memento = memento.getChild(key)) != null && (ws = this.fWSManager.createWorkingSet(memento)) != null) {
            this.fWorkingSet = this.fWSManager.getWorkingSet(ws.getName());
            if (this.fWorkingSet == null) {
                this.fWorkingSet = ws;
                this.fWSManager.addWorkingSet(ws);
            }
        }
        this.fWorkingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WorkingSetFilterUI.this.onWorkingSetPropertyChange(event);
            }
        };
        this.fWSManager.addPropertyChangeListener(this.fWorkingSetListener);
        IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WorkingSetFilterUI.this.onWorkingSetFilterUpdate(event);
            }
        };
        this.fWorkingSetFilterGroup = new WorkingSetFilterActionGroup(this.fViewPart.getSite().getShell(), workingSetUpdater);
        this.fWorkingSetFilterGroup.setWorkingSet(this.fWorkingSet);
    }

    public void dispose() {
        this.fWSManager.removePropertyChangeListener(this.fWorkingSetListener);
        this.fWorkingSetFilterGroup.dispose();
    }

    private void applyWorkingSetFilter() {
        if (this.fWorkingSet == null) {
            this.fWorkingSetFilter = null;
        } else {
            this.fWorkingSetFilter = new WorkingSetFilter();
            this.fWorkingSetFilter.setWorkingSet(this.fWorkingSet);
        }
    }

    protected void onWorkingSetPropertyChange(PropertyChangeEvent evt) {
        if (this.fWorkingSet == null) {
            return;
        }
        boolean doRefresh = false;
        String propertyName = evt.getProperty();
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (propertyName.equals("workingSetContentChange")) {
            if (this.fWorkingSet == newValue) {
                doRefresh = true;
            }
        } else if (propertyName.equals("workingSetNameChange")) {
            if (this.fWorkingSet == newValue) {
                this.onWorkingSetNameChange();
            }
        } else if (propertyName.equals("workingSetRemove") && this.fWorkingSet == oldValue) {
            this.fWorkingSet = null;
            doRefresh = true;
        }
        if (doRefresh) {
            this.applyWorkingSetFilter();
            this.onWorkingSetChange();
        }
    }

    protected void onWorkingSetFilterUpdate(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("changeWorkingSet".equals(property)) {
            Object newValue = event.getNewValue();
            if (newValue instanceof IWorkingSet) {
                this.fWorkingSet = (IWorkingSet)newValue;
                this.fWSManager.addRecentWorkingSet(this.fWorkingSet);
            } else {
                this.fWorkingSet = null;
            }
            this.applyWorkingSetFilter();
            this.onWorkingSetChange();
            this.onWorkingSetNameChange();
        }
    }

    protected abstract void onWorkingSetChange();

    protected abstract void onWorkingSetNameChange();

    public void fillActionBars(IActionBars actionBars) {
        this.fWorkingSetFilterGroup.fillActionBars(actionBars);
    }

    public boolean isPartOfWorkingSet(ICElement element) {
        if (this.fWorkingSetFilter == null) {
            return true;
        }
        return this.fWorkingSetFilter.isPartOfWorkingSet(element);
    }

    public boolean isPartOfWorkingSet(IPath resourceOrExternalPath) {
        if (this.fWorkingSetFilter == null) {
            return true;
        }
        return this.fWorkingSetFilter.isPartOfWorkingSet(resourceOrExternalPath);
    }

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
        this.fWorkingSetFilterGroup.setWorkingSet(this.fWorkingSet);
    }

    public List<String> getRecent() {
        IWorkingSet[] workingSets = this.fWSManager.getRecentWorkingSets();
        ArrayList<String> result = new ArrayList<String>(workingSets.length);
        int i = 0;
        while (i < workingSets.length) {
            result.add(workingSets[i].getName());
            ++i;
        }
        return result;
    }

    public void saveState(IMemento memento, String key) {
        if (this.fWorkingSet != null) {
            this.fWorkingSet.saveState(memento.createChild(key));
        }
    }
}

