/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectImmutableModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

public class SchemaObjectEditorInput
implements ISchemaObjectEditorInput {
    IEditorDescriptor _editor;
    ISchemaObjectEditModel _modelObject;
    DatabaseIdentifier _databaseIdentifier;

    public SchemaObjectEditorInput(IEditorDescriptor editor, ISchemaObjectEditModel modelObject, DatabaseIdentifier identifier) {
        this._editor = editor;
        this._modelObject = modelObject;
        this._databaseIdentifier = identifier;
    }

    @Override
    public IEditorDescriptor getEditorDescriptor() {
        return this._editor;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this._modelObject.getMainSQLObject() != null && this._modelObject.getMainSQLObject().getName() != null) {
            return this._modelObject.getMainSQLObject().getName();
        }
        return Messages.SchemaObjectEditorInput_name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this._modelObject != null && this._modelObject.getEditorTooltipText() != null) {
            return this._modelObject.getEditorTooltipText();
        }
        return Messages.SchemaObjectEditorInput_name;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IConnectionProfile.class) {
            try {
                return ProfileUtil.getProfile((String)this._databaseIdentifier.getProfileName());
            }
            catch (NoSuchProfileException noSuchProfileException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public ISchemaObjectEditModel getEditModelObject() {
        return this._modelObject;
    }

    @Override
    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ISchemaObjectEditorInput)) {
            return false;
        }
        ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)obj;
        ISchemaObjectImmutableModel originalModel = input.getEditModelObject().getSchemaObjectImmutableModel();
        return originalModel.equals(this.getEditModelObject().getSchemaObjectImmutableModel());
    }
}

