/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.terminal.ui;

import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.ILog;
import org.eclipse.debug.terminal.ui.TerminalConsole;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.handlers.IHandlerService;

public class TerminalConsoleFactory
implements IConsoleFactory {
    public void openConsole() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (commandService == null || handlerService == null) {
            return;
        }
        Command command = commandService.getCommand("org.eclipse.terminal.view.ui.command.launchConsole");
        if (command == null) {
            return;
        }
        ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((Command)command, Map.of());
        try {
            Object result = handlerService.executeCommandInContext(parameterizedCommand, null, handlerService.getCurrentState());
            if (result instanceof ITerminalConnector) {
                ITerminalConnector terminalConnector = (ITerminalConnector)result;
                TerminalConsole console = new TerminalConsole(terminalConnector);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            }
        }
        catch (Exception e) {
            ILog.get().error("Can't launch terminal console", (Throwable)e);
        }
    }
}

