/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal;

import java.util.Objects;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.jface.resource.ImageDescriptor;

public class InternalCursor {
    private static final ImageDescriptor CURSOR_AT_100_ZOOM = InternalImages.createDescriptor("icons/cursor@1x.svg");
    private static final ImageDescriptor CURSOR_AT_150_ZOOM = InternalImages.createDescriptor("icons/cursor@1.5x.svg");
    private static final ImageDescriptor CURSOR_AT_200_ZOOM = InternalImages.createDescriptor("icons/cursor@2x.svg");
    private static ImageDescriptor CURRENT_CURSOR_DESCRIPTOR = ImageDescriptor.createFromImageDataProvider(zoom -> {
        if (zoom < 150) {
            return CURSOR_AT_100_ZOOM.getImageData(100);
        }
        if (zoom < 200) {
            return CURSOR_AT_150_ZOOM.getImageData(100);
        }
        return CURSOR_AT_200_ZOOM.getImageData(100);
    });

    public static ImageDescriptor getCursorDescriptor() {
        return CURRENT_CURSOR_DESCRIPTOR;
    }

    public static void setCursorDescriptor(ImageDescriptor cursorDescriptor) {
        Objects.requireNonNull(cursorDescriptor, "The new cursor descriptor must not be null!");
        CURRENT_CURSOR_DESCRIPTOR = cursorDescriptor;
    }
}

