/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;

public class SetConstraintCommand
extends Command {
    private static final String COMMAND_LABEL_LOCATION = PageflowMessages.SetConstraintCommand_Location;
    private static final String COMMAND_LABEL_RESIZE = PageflowMessages.SetConstraintCommand_Resize;
    private Point newPos;
    private Dimension newSize;
    private Point oldPos;
    private Dimension oldSize;
    private PageflowElement part;

    public void execute() {
        this.oldSize = new Dimension(this.part.getWidth(), this.part.getHeight());
        this.oldPos = new Point(this.part.getX(), this.part.getY());
        this.part.setX(this.newPos.x);
        this.part.setY(this.newPos.y);
        this.part.setHeight(this.newSize.height);
        this.part.setWidth(this.newSize.width);
    }

    public void redo() {
        this.part.setX(this.newPos.x);
        this.part.setY(this.newPos.y);
        this.part.setHeight(this.newSize.height);
        this.part.setWidth(this.newSize.width);
    }

    public void undo() {
        this.part.setX(this.oldPos.x);
        this.part.setY(this.oldPos.y);
        this.part.setHeight(this.oldSize.height);
        this.part.setWidth(this.oldSize.width);
    }

    public String getLabel() {
        if (this.oldSize.equals((Object)this.newSize)) {
            return COMMAND_LABEL_LOCATION;
        }
        return COMMAND_LABEL_RESIZE;
    }

    public void setLocation(Rectangle r) {
        this.setLocation(r.getLocation());
        this.setSize(r.getSize());
    }

    public void setLocation(Point p) {
        this.newPos = p;
    }

    public void setPart(PageflowElement part) {
        this.part = part;
    }

    public void setSize(Dimension p) {
        this.newSize = p;
    }
}

