/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.internal.cxf.core.CXFCoreMessages;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.context.Java2WSPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFInstall;

public class CXFClasspathContainer
implements IClasspathContainer {
    private IPath path;
    private List<IClasspathEntry> classpathEntries;
    private IProject project;
    private String installed;

    public CXFClasspathContainer(IPath path, IJavaProject javaProject) {
        this.path = path;
        this.project = javaProject.getProject();
        this.classpathEntries = new ArrayList<IClasspathEntry>();
    }

    public IClasspathEntry[] getClasspathEntries() {
        File cxfLibDirectory;
        if (!this.installed.equals(CXFCorePlugin.getDefault().getCXFRuntimeVersion(this.project))) {
            this.classpathEntries.clear();
        }
        if (this.classpathEntries.size() == 0 && (cxfLibDirectory = this.getCXFLibraryDirectory()).exists() && cxfLibDirectory.isDirectory()) {
            String[] files = cxfLibDirectory.list();
            int i = 0;
            while (i < files.length) {
                File file = new File(String.valueOf(cxfLibDirectory.getPath()) + File.separator + files[i]);
                String fileName = file.getName();
                if (fileName.indexOf(".") != -1 && fileName.substring(fileName.lastIndexOf("."), fileName.length()).equals(".jar")) {
                    this.classpathEntries.add(JavaCore.newLibraryEntry((IPath)new Path(file.getAbsolutePath()), null, (IPath)new Path("/")));
                }
                ++i;
            }
        }
        return this.classpathEntries.toArray(new IClasspathEntry[this.classpathEntries.size()]);
    }

    public boolean isValid() {
        if (this.getCxfRuntimeLocation().length() > 0) {
            File cxfLibDirectory = this.getCXFLibraryDirectory();
            return cxfLibDirectory.exists() && cxfLibDirectory.isDirectory();
        }
        return false;
    }

    public String getDescription() {
        return MessageFormat.format(CXFCoreMessages.CXF_CONTAINER_LIBRARY, this.getCxfRuntimeType(), this.getCxfRuntimeVersion());
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    private CXFInstall getCxfInstall() {
        String installed;
        this.installed = installed = CXFCorePlugin.getDefault().getCXFRuntimeVersion(this.project);
        Java2WSPersistentContext context = CXFCorePlugin.getDefault().getJava2WSContext();
        CXFInstall cxfInstall = context.getInstallations().get(installed);
        return cxfInstall;
    }

    private String getCxfRuntimeLocation() {
        CXFInstall cxfInstall = this.getCxfInstall();
        if (cxfInstall != null) {
            return cxfInstall.getLocation();
        }
        return CXFCorePlugin.getDefault().getJava2WSContext().getDefaultRuntimeLocation();
    }

    private String getCxfRuntimeVersion() {
        CXFInstall cxfInstall = this.getCxfInstall();
        if (cxfInstall != null) {
            return cxfInstall.getVersion();
        }
        return CXFCorePlugin.getDefault().getJava2WSContext().getDefaultRuntimeVersion();
    }

    private String getCxfRuntimeType() {
        CXFInstall cxfInstall = this.getCxfInstall();
        if (cxfInstall != null) {
            return cxfInstall.getType();
        }
        return CXFCorePlugin.getDefault().getJava2WSContext().getDefaultRuntimeType();
    }

    private File getCXFLibraryDirectory() {
        Path cxfLibPath = new Path(this.getCxfRuntimeLocation());
        if (!cxfLibPath.hasTrailingSeparator()) {
            cxfLibPath = cxfLibPath.addTrailingSeparator();
        }
        cxfLibPath = cxfLibPath.append("lib");
        File cxfLibDirectory = new File(cxfLibPath.toOSString());
        return cxfLibDirectory;
    }
}

