/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;

public class ResolverUtils {
    private ResolverUtils() {
    }

    private static String getNamespaceQuery(URI unitURI) {
        String query = unitURI.query();
        if (query == null || query.trim().length() == 0) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(query, "&");
        while (tok.hasMoreElements()) {
            String key;
            String pair = ((String)tok.nextElement()).trim();
            int index = pair.indexOf(61);
            if (index <= 0 || !"ns".equals((key = pair.substring(0, index)).trim())) continue;
            String val = pair.substring(index + 1).trim();
            return val.trim();
        }
        return null;
    }

    public static URI getSourceFolderURI(URI uri) {
        URI result;
        String ns = ResolverUtils.getNamespaceQuery(uri);
        if (ns == null) {
            return null;
        }
        if (".".equals(ns)) {
            result = uri.trimSegments(1);
        } else {
            String[] segments = ResolverUtils.getNameSegments(ns);
            result = uri.trimSegments(segments.length + 1);
        }
        return result.appendSegment("").trimQuery();
    }

    public static String getNamespace(IPath namespacePath, IPath srcContainerPath) {
        if (namespacePath == null || srcContainerPath == null) {
            throw new IllegalArgumentException();
        }
        if (namespacePath.equals((Object)srcContainerPath)) {
            return null;
        }
        int srcContainerDepth = srcContainerPath.segmentCount();
        IPath srcRelativePath = namespacePath.removeFirstSegments(srcContainerDepth);
        return ResolverUtils.getNamespace(srcRelativePath);
    }

    public static String getNamespace(IPath srcRelativePath) {
        StringBuilder buf = new StringBuilder();
        String[] segments = srcRelativePath.segments();
        int i = 0;
        while (i < segments.length) {
            if (i > 0) {
                buf.append('.');
            }
            buf.append(segments[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String toQualifiedName(String path) {
        return path.replace('/', '.');
    }

    public static String toQualifiedName(IPath path) {
        return ResolverUtils.toQualifiedName(path.toString());
    }

    public static String toQualifiedName(String[] nameSegments, int startPos, int endPos) {
        int len = nameSegments.length;
        if (startPos > endPos || startPos < 0 || startPos >= len || endPos < 0 || endPos >= len) {
            throw new ArrayIndexOutOfBoundsException("name segment position");
        }
        StringBuilder buf = new StringBuilder();
        int i = startPos;
        while (i <= endPos) {
            if (i > startPos) {
                buf.append('.');
            }
            buf.append(nameSegments[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String[] getNameSegments(String qualifiedName) {
        return qualifiedName.split("\\.");
    }

    public static String toNamespaceRelativeUnitFilePath(String qualifiedName) {
        return String.valueOf(qualifiedName.replace('.', '/')) + ".qvto";
    }

    public static UnitContents.CSTContents createCSTContents(final String input) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        return new UnitContents.CSTContents(){

            @Override
            public Reader getContents() throws IOException {
                return new StringReader(input);
            }
        };
    }

    public static String getQueryValue(URI uri, String key) {
        if (uri.hasQuery()) {
            String[] queries;
            String[] stringArray = queries = uri.query().split("&");
            int n = queries.length;
            int n2 = 0;
            while (n2 < n) {
                String query = stringArray[n2];
                String[] parts = query.split("=");
                if (parts.length > 1 && key.equals(parts[0])) {
                    return parts[1];
                }
                ++n2;
            }
        }
        return null;
    }
}

